### Name: heatplot
### Title: Draws heatmap with dendrograms.
### Aliases: heatplot
### Keywords: hplot manip

### ** Examples

data(khan)

heatplot(khan$train[1:30,], lowcol="blue", highcol="red")
heatplot(khan$train[1:26,], lowcol="blue", highcol="red", 
         labRow = c(64:1), labCol=LETTERS[1:26])

if (require(ade4, quiet = TRUE)) {
khan.coa<-dudi.coa(khan$train, scan=FALSE, nf=6)
}

# Provides a view of the components of the Correspondence analysis 
heatplot(khan.coa$li, dend=FALSE)   

# transposed so that it is easier to view. Can see that the difference between tissues 
# and cell line samples are defined in the first axis.

heatplot(t(khan.coa$li), dend=FALSE, lowcol="blue") 




