### Name: reverseEdgeDirections
### Title: Reverse the edges of a directed graph
### Aliases: reverseEdgeDirections
### Keywords: manip

### ** Examples

g <- new("graphNEL", nodes=c("a", "b", "c"),
         edgeL=list(a=c("b", "c"), b=character(0), c=character(0)),
         edgemode="directed")

stopifnot(isAdjacent(g, "a", "b"))
stopifnot(!isAdjacent(g, "b", "a"))

grev <- reverseEdgeDirections(g)
stopifnot(!isAdjacent(grev, "a", "ab"))
stopifnot(isAdjacent(grev, "b", "a"))




