/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.gaggle.network;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.systemsbiology.gaggle.network.Interaction;

public class Network
implements Serializable {
    ArrayList interactionList = new ArrayList();
    HashMap nodeAttributes;
    HashMap edgeAttributes;
    HashSet nodes = new HashSet();
    String species = "unknown";

    public Network() {
        this.nodeAttributes = new HashMap();
        this.edgeAttributes = new HashMap();
    }

    public void add(Interaction interaction) {
        this.interactionList.add(interaction);
        this.add(interaction.getSource());
        this.add(interaction.getTarget());
    }

    public void add(String string) {
        this.nodes.add(string);
    }

    public void add(Interaction[] interactionArray) {
        for (int i = 0; i < interactionArray.length; ++i) {
            this.add(interactionArray[i]);
        }
    }

    public Interaction[] getInteractions() {
        return this.interactionList.toArray(new Interaction[0]);
    }

    public int nodeCount() {
        return this.nodes.size();
    }

    public String[] getNodes() {
        return this.nodes.toArray(new String[0]);
    }

    public HashSet getConnectedNodes() {
        HashSet<String> hashSet = new HashSet<String>();
        Interaction[] interactionArray = this.getInteractions();
        for (int i = 0; i < interactionArray.length; ++i) {
            hashSet.add(interactionArray[i].getSource());
            hashSet.add(interactionArray[i].getTarget());
        }
        return hashSet;
    }

    public String[] getOrphanNodes() {
        HashSet<String> hashSet = new HashSet<String>();
        HashSet hashSet2 = this.getConnectedNodes();
        String[] stringArray = this.getNodes();
        for (int i = 0; i < stringArray.length; ++i) {
            if (hashSet2.contains(stringArray[i])) continue;
            hashSet.add(stringArray[i]);
        }
        return hashSet.toArray(new String[0]);
    }

    public int getOrphanNodeCount() {
        return this.getOrphanNodes().length;
    }

    public int edgeCount() {
        return this.interactionList.size();
    }

    public void addEdgeAttribute(String string, String string2, Object object) {
        if (!this.edgeAttributes.containsKey(string2)) {
            this.edgeAttributes.put(string2, new HashMap());
        }
        HashMap hashMap = (HashMap)this.edgeAttributes.get(string2);
        hashMap.put(string, object);
    }

    public void addNodeAttribute(String string, String string2, Object object) {
        if (!this.nodeAttributes.containsKey(string2)) {
            this.nodeAttributes.put(string2, new HashMap());
        }
        HashMap hashMap = (HashMap)this.nodeAttributes.get(string2);
        hashMap.put(string, object);
    }

    public String[] getNodeAttributeNames() {
        return this.nodeAttributes.keySet().toArray(new String[0]);
    }

    public String[] getEdgeAttributeNames() {
        return this.edgeAttributes.keySet().toArray(new String[0]);
    }

    public HashMap getEdgeAttributes(String string) {
        return (HashMap)this.edgeAttributes.get(string);
    }

    public HashMap getNodeAttributes(String string) {
        return (HashMap)this.nodeAttributes.get(string);
    }

    public void setSpecies(String string) {
        this.species = string;
    }

    public String getSpecies() {
        return this.species;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Interaction[] interactionArray = this.getInteractions();
        for (int i = 0; i < interactionArray.length; ++i) {
            stringBuffer.append(interactionArray[i].toString());
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }
}

