### Name: normalizeChannels
### Title: Normalization of dual-channel data and data transformation
### Aliases: normalizeChannels
### Keywords: manip

### ** Examples

 ## Not run: 
##D     datadir <- system.file("DualChannelScreen", package = "cellHTS")
##D     x <- readPlateData("Platelist.txt", "TwoColorData", path=datadir)
##D     confFile <- system.file("DualChannelScreen", "Plateconf.txt", package="cellHTS")
##D     logFile  <- system.file("DualChannelScreen", "Screenlog.txt", package="cellHTS")
##D     descripFile <- system.file("DualChannelScreen", "Description.txt", package="cellHTS")
##D     x <- configure(x, confFile, logFile, descripFile)
##D     table(x$wellAnno)
##D 
##D     ## Define the controls for the different channels:
##D     negControls=vector("character", length=dim(x$xraw)[4])
##D 
##D     ## channel 1 - gene A
##D     ## case-insensitive and match the empty string at the beginning and end of a line (to distinguish between "geneA" and "geneAB", for example, although this is not a problem for the well annotation in this example)
##D 
##D     negControls[1]= "(?i)^geneA$"  
##D     ## channel 2 - gene A and geneB
##D     negControls[2]= "(?i)^geneA$|^geneB$" 
##D     posControls = vector("character", length=dim(x$xraw)[4])
##D     ## channel 1 - no controls
##D     ## channel 2 - geneC and geneD
##D     posControls[2]="(?i)^geneC$|^geneD$"
##D 
##D     writeReport(x, posControls=posControls, negControls=negControls)
##D     x = normalizeChannels(x, fun=function(x,y) y/x, log=TRUE, adjustPlates="median")
##D     ## Define the controls for the normalized intensities (only one channel):
##D     negControls = vector("character", length=dim(x$xnorm)[4])
##D     ## For the single channel, the negative controls are geneA and geneB 
##D     negControls[1]= "(?i)^geneA$|^geneB$" 
##D     posControls = vector("character", length=dim(x$xnorm)[4])
##D     ## For the single channel, the negative controls are geneC and geneD 
##D     posControls[1]="(?i)^geneC$|^geneD$"
##D     writeReport(x, force=TRUE, plotPlateArgs=list(xrange=c(-3,3)), 
##D          posControls=posControls, negControls=negControls)
##D  
## End(Not run)



