angular.module('stock')
    .controller('ListController', ListController);

ListController.$inject = ['stockItems', '$timeout'];

function ListController(stockItems, $timeout) {
    var vm = this;
    vm.pos = '';
    vm.neg = '';
    vm.timeout = null;
    vm.edit = null;
    vm.value = null;
    vm.stockItems = stockItems;
    vm.increase = stockItems.increase;
    vm.decrease = stockItems.decrease;
    vm.save = save;
    vm.editItem = editItem;

    function init() {
        stockItems.get();
        stockItems.on('positive', increaseDecrease.bind(vm, 'pos'));
        stockItems.on('negative', increaseDecrease.bind(vm, 'neg'));
        stockItems.on('locked', locked);
    }

    function lock (item) {
        item.lock = true;
        stockItems.save(item)
    }

    function locked(info) {
        toggleLocked(info.data.id, vm.stockItems.stockItems, true);
    }

    function toggleLocked(id, stockItems, locked) {
        for (var i = 0; i < stockItems.length; i++) {
            if (stockItems[i].id === id) {
                stockItems[i].locked = locked;
            }
        }
    }

    function increaseDecrease(direction, id) {
        toggleLocked(id, this.stockItems.stockItems, false);
        this.pos = '';
        this.neg = '';
        this[direction] = id;

        if (this.timeout) {
            $timeout.cancel(this.timeout);
        }

        this.timeout = $timeout(function () {
            this.pos = '';
            this.neg = '';
        }.bind(this), 1000);
    }

    function save() {
        var data = {
            id: vm.edit,
            stock: parseInt(vm.value)
        };
        stockItems.save(data);
        vm.edit = null;
        vm.value = null;
    }

    function editItem(item) {
        if (item.locked) {
            return;
        }

        var data = item;
        data.locked = true;
        stockItems.save(data);
        vm.edit = item.id;
        var items = vm.stockItems.stockItems;
        for (var i = 0; i < items.length; i++) {
            if (items[i].id === item.id) {
                vm.value = items[i].stock;
                break;
            }
        }
    }

    init();
}
