var express = require('express');
var app = express();
require('express-ws')(app);

var mysql = require('mysql');
var connection = mysql.createConnection({
    host: 'localhost',
    user: 'root',
    password: '',
    database: 'reactive'
});

WSStream = function (ws) {
    var Duplex = require('stream').Duplex;
    var stream = Duplex({objectMode: true});
    stream._write = function (chunk, enc, next) {
        ws.send(JSON.stringify(chunk));
        next();
    };
    stream._read = function () {
        ws.once('message', function (msg) {
            stream.push(JSON.parse(msg));
        });
    };
    return stream;
};

connection.connect();

app.use(express.static('public'));

var sockets = [];

app.ws('/stockItems', function (ws, req) {
    var stream = WSStream(ws);

    sockets.push(ws);

    ws.on('close', function () {
        sockets.splice(sockets.indexOf(ws), 1);
    });

    ws.on('error', function (data) {
        console.log(data);
    });

    stream.on('readable', function () {
        var msg = stream.read();
        if (msg.action === 'get') {
            connection.query('SELECT * FROM articles')
                .stream()
                .pipe(stream);
        }

        if (msg.action == 'save') {
            if (!(msg.data && msg.data.stock && msg.data.id)) {
                return;
            }
            var data = [
                msg.data.stock,
                msg.data.locked ? 1 : 0,
                msg.data.id
            ];
            connection.query('SELECT * FROM articles WHERE id = ?', [msg.data.id])
                .on('result', function (item) {
                    connection.query('UPDATE articles SET stock = ?, locked = ? WHERE id = ?', data)
                        .on('result', function () {
                            var type = '';
                            if (item.stock < msg.data.stock) {
                                type = 'positive';
                            } else if (item.stock === msg.data.stock && msg.data.locked) {
                                type = 'locked';
                            } else {
                                type = 'negative';
                            }

                            sockets.forEach(function (socket) {
                                socket.send(JSON.stringify({
                                    action: type,
                                    data: msg.data
                                }));
                            });
                        });
                });
        }
    });

});

app.listen(8080);


