/* printHistogram.cpp */

void printHistogram() {
  const int NNUM=10000;
  const int NBINS=20;

  // Create a suitable random number generator
  std::normal_distribution<> nd(10,3);
  std::random_device generator;

  // A histogram in the range [0:NBINS], initialized with 0
  std::vector<int> hist(NBINS,0);

  // Generate NNUM gaussian distributed random numbers with mean 10, sigma 3
  int fillPos;
  for(int i=0; i<NNUM; i++){
    // Find a new position to fill
    fillPos=(int)std::floor(nd(generator));

    // Increment histogram bins where possible
    if(fillPos >= 0 && fillPos<NBINS) hist.at(fillPos) += 1;
  }

  // Output the y-axis
  std::cout << "+" << std::string(65,'-') << "> Entries" << std::endl;

  // Output scaled histogram entries.
  int histPos=0, maxContent=*std::max_element(hist.begin(), hist.end());
  for(int nContent: hist){
    std::cout << "| " << (histPos<10?"0":"") << histPos << "-" << (histPos<9?"0":"") << histPos+1 << "\t";   
    std::cout << std::string(std::size_t(50.*double(nContent)/maxContent), ' ') << "| " << nContent << std::endl;
    histPos++;
  }
  std::cout << "v" << std::endl << "Euros" << std::endl;
}

#ifdef __CLING__
void simpleHistogram() {
#else
int main(int argc, char** argv) {
#endif
  // Output the histogram
  printHistogram();
}
