import bpy

class MyMouseOperator(bpy.types.Operator):
    """ Info über Mauspostion """
    bl_idname = "wm.mouse_position"
    bl_label = "Show mouse postion"
    
    x = bpy.props.IntProperty(name="x",default=0)
    y = bpy.props.IntProperty(name="y",default=0)
    
    def invoke(self,context,event):
        self.x = event.mouse_x
        self.y = event.mouse_y
        return self.execute(context)
    
    def execute(self,xontext):
        self.report({'INFO'},"Mauspostion %d, %d" % (self.x,self.y))
        return {'FINISHED'}
    
def menu_func(self,context): #Funktion für Menü
    self.layout.operator(MyMouseOperator.bl_idname) 

def register():
    bpy.utils.register_class(MyMouseOperator)
    bpy.types.VIEW3D_MT_view.append(menu_func) 
    
register()