import bpy

class MyLayoutPanel(bpy.types.Panel):
    bl_idname = "VIEW3D_PT_myLayoutPanel"
    bl_label = "MyLayoutPanel"
    
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'TOOL_PROPS'

    def draw(self, context):
        layout = self.layout
        layout.label("Erster Text",icon="WORLD")
        
        row = layout.row()
        row.alignment = 'LEFT'
        
        col = row.column()
        col.operator("view3d.viewnumpad", text="Front").type='FRONT'
        col.operator("view3d.viewnumpad", text="Left").type='LEFT'
        col.operator("view3d.viewnumpad", text="Top").type='TOP'
        col = row.column()
        col.operator("view3d.viewnumpad", text="Back").type='BACK'
        col.operator("view3d.viewnumpad", text="Right").type='RIGHT'
        col.operator("view3d.viewnumpad", text="Bottom").type='BOTTOM'
        
        row = layout.row()
        box = row.box()
        box.operator("view3d.viewnumpad", text="View Camera",icon='CAMERA_DATA').type='CAMERA'
                        
bpy.utils.register_module(__name__)

