package ix.datamodel;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
public class Teilnehmer implements Serializable {

    private static final long serialVersionUID = 1L;

    @Id
    @GeneratedValue
    private Long id;

    @Basic
    private String name;

    @Basic
    private String email;

    @Basic
    @Temporal(TemporalType.DATE)
    @Column(nullable = true)
    private Date geburtstag;

    @Basic
    private int anzahlBegleitpersonen = 0;

    @Basic
    private boolean vortragender = false;

    @ManyToOne
    private Veranstaltung veranstaltung;

    public Teilnehmer() {

    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Date getGeburtstag() {
        return geburtstag;
    }

    public void setGeburtstag(Date geburtstag) {
        this.geburtstag = geburtstag;
    }

    public int getAnzahlBegleitpersonen() {
        return anzahlBegleitpersonen;
    }

    public void setAnzahlBegleitpersonen(int anzahlBegleitpersonen) {
        this.anzahlBegleitpersonen = anzahlBegleitpersonen;
    }

    public boolean isVortragender() {
        return vortragender;
    }

    public void setVortragender(boolean vortragender) {
        this.vortragender = vortragender;
    }

    public Veranstaltung getVeranstaltung() {
        return veranstaltung;
    }

    public void setVeranstaltung(Veranstaltung veranstaltung) {
        this.veranstaltung = veranstaltung;
    }
    
    @Override
    public int hashCode()
    {
        int hash = 0;
        hash += (id != null ? id.hashCode() : 0);
        return hash;
    }

    @Override
    public boolean equals(Object object)
    {
        // TODO: Warning - this method won't work in the case the id fields are not set
        if (!(object instanceof Teilnehmer))
        {
            return false;
        }
        Teilnehmer other = (Teilnehmer) object;
        if ((this.id == null && other.id != null) || (this.id != null && !this.id.equals(other.id)))
        {
            return false;
        }
        return true;
    }
}
