using System;

using Microsoft.SqlServer.Management.Common;
using Microsoft.SqlServer.Management.Smo;

namespace GenerateObjectScript
{
    class Program
    {
        static Int32 Main(string[] args)
        {
            try
            {
                if (args.Length != 4)
                    throw new ArgumentException("Four arguments must be specified: data-source initial-catalog schema-name object-name");

                ServerConnection SrvConn = new ServerConnection();
                SrvConn.AutoDisconnectMode = AutoDisconnectMode.NoAutoDisconnect;
                SrvConn.NonPooledConnection = true;
                SrvConn.StatementTimeout = 3000;

                // set only server name and database name;
                // the connection is then established using Windows authentication
                // (LoginSecure property is "true" by default)
                SrvConn.ServerInstance = args[0];
                SrvConn.DatabaseName = args[1];

                try
                {
                    ScriptingOptions SO;
                    System.Collections.Specialized.StringCollection SColl;

                    // connect to server and database
                    Server Srv = new Server(SrvConn);
                    Database Db = Srv.Databases[(String)SrvConn.ExecuteScalar("select db_name()")];

                    // get target table
                    Table MyTable = Db.Tables[args[3], args[2]];

                    // generate script for *** table body ***

                    SO = BasicScriptingOptions;

                    SO.AnsiPadding = true;

                    SO.DriClustered = true;
                    SO.DriDefaults = true;
                    SO.DriIncludeSystemNames = true;
                    SO.DriPrimaryKey = true;
                    SO.DriChecks = true;
                    SO.Permissions = true;

                    SColl = MyTable.Script(SO);

                    foreach (String S in SColl)
                        Console.WriteLine(S);
                }
                finally
                {
                    // always disconnect!
                    if (SrvConn.IsOpen)
                        SrvConn.Disconnect();
                }
            }
            catch (Exception ex)
            {
                Console.WriteLine("Error encountered: {0}: {1} {2}", ex.Source, ex.Message, ex.StackTrace);
                return 666;
            }

            return 0;
        }

        private static ScriptingOptions BasicScriptingOptions
        {
            get
            {
                ScriptingOptions SO = new ScriptingOptions();
                SO.Encoding = System.Text.Encoding.Unicode;
                SO.IncludeHeaders = false; // don't add comments into generated scripts
                SO.NoFileGroup = true;
                return SO;
            }
        }
    }
}
