using System;
using System.Diagnostics;
using System.Data.SqlClient;
using Microsoft.SqlServer.Server;

namespace ScriptGenerators
{
    public class GenerateTableScript
    {
        [SqlFunction(DataAccess = DataAccessKind.Read)]
        public static String Generate(String SchemaName, String ObjectName)
        {
            Util Utl = new Util();

            String Result;

            using (SqlConnection SqlConn = new SqlConnection("context connection=true"))
            {
                SqlConn.Open();

                SqlCommand Cmd = SqlConn.CreateCommand();

                Cmd.CommandText = "select @@servername";
                String SqlDataSource = (String)Cmd.ExecuteScalar();

                Cmd.CommandText = "select db_name()";
                String SqlInitialCatalog = (String)Cmd.ExecuteScalar();

                Result = Utl.ExecuteExternalProg(
                    null, @"D:\CLRIntegrationTest\GenerateObjectScript.exe",
                    "\"" + SqlDataSource + "\" " +
                    "\"" + SqlInitialCatalog + "\" " +
                    "\"" + SchemaName + "\" " +
                    "\"" + ObjectName + "\"",
                    15, 0, true);
            }

            return Result;
        }
    }

    class Util
    {
        private String StdOutBuffer;

        public String ExecuteExternalProg(String WorkDir, String ProgName, String Arguments, Int32 TimeoutSeconds, Int32 AwaitedExitCode, bool CheckForExitCode)
        {
            ProcessStartInfo PSI = new ProcessStartInfo(ProgName, Arguments);
            PSI.WindowStyle = ProcessWindowStyle.Hidden;
            PSI.UseShellExecute = false;
            PSI.RedirectStandardOutput = true;

            if (WorkDir != null)
                PSI.WorkingDirectory = WorkDir;

            Process P = new System.Diagnostics.Process();
            P.StartInfo = PSI;
            P.OutputDataReceived += new DataReceivedEventHandler(P_OutputDataReceived);
            StdOutBuffer = "";
            P.Start();
            P.BeginOutputReadLine();

            if (TimeoutSeconds == -1)
                P.WaitForExit();
            else
            {
                if (!P.WaitForExit(TimeoutSeconds * 1000))
                {
                    P.Kill();
                    throw new Exception("Process has not exited during the specified time. Console:\r\n" + StdOutBuffer);
                }
                P.WaitForExit(); // this is needed to complete the redirected asynchronous output
            }

            String Result = StdOutBuffer;

            if (CheckForExitCode)
                if (P.ExitCode != AwaitedExitCode)
                    throw new Exception(Result);

            return Result;
        }

        private void P_OutputDataReceived(object sendingProcess, DataReceivedEventArgs outLine)
        {
            StdOutBuffer += outLine.Data;
            StdOutBuffer += "\r\n";
        }
    }
}
