﻿using Datenzugriff;
using Modell;
using System;
using System.Data.Entity;
using System.Data.Entity.Infrastructure;
using System.IO;
using System.Linq;
using System.Net;
using System.Net.Http;
using System.Net.Http.Headers;
using System.Web;
using System.Web.Http;
using System.Web.Http.Description;

namespace Website.Controllers
{
 public class VeranstaltungAPIController : ApiController // ApiController // ODataController
 {
  private EFKontext db = new EFKontext();

  [Queryable]
 // [ODataRoutePrefix] ab v2.2
  // GET api/VeranstaltungAPI
  public IQueryable<Veranstaltung> GetVeranstaltungSet() // List<T> // für OData: GetVeranstaltungSet
  {
   return db.VeranstaltungsSet;
  }

  

  // GET api/VeranstaltungAPI/5
  [ResponseType(typeof(Veranstaltung))]
  [System.Web.Http.ActionName("ID")]
  public IHttpActionResult GetVeranstaltung(int id) // [FromUri(Name = "Veranstaltungsnummer")] 
  {
   Veranstaltung veranstaltung = db.VeranstaltungsSet.Find(id);
   if (veranstaltung == null)
   {
    return NotFound();
   }

   return Ok(veranstaltung);
  }


  // Möglich, aber liefert im Fall von Objekt nicht gefunden, leeres XML statt Fehlercode 404
  // GET api/VeranstaltungAPI/5
  //[ResponseType(typeof(Veranstaltung))]
  //[System.Web.Http.ActionName("ID")]
  //public Veranstaltung GetVeranstaltung([FromUri(Name = "Veranstaltungsnummer")] int id)
  //{
  // Veranstaltung veranstaltung = db.VeranstaltungsSet.Find(id);

  // return veranstaltung;
  //}


  // Liefert das Logo als Binärstream
  [Route("api/VeranstaltungAPI/Logo")]
  public HttpResponseMessage GetLogo()
  {
   var path = HttpContext.Current.Server.MapPath("~/content/www.IT-Visions.de.png");
   HttpResponseMessage result = new HttpResponseMessage(HttpStatusCode.OK);
   var stream = new FileStream(path, FileMode.Open);
   result.Content = new StreamContent(stream);
   result.Content.Headers.ContentType =
    new MediaTypeHeaderValue("application/octet-stream");
   result.Headers.CacheControl.Public = true;
   return result;
  }


  // GET api/VeranstaltungAPI/Name/Namensteil
  //[System.Web.Http.ActionName("Name")]
  [Route("api/VeranstaltungAPI/Veranstaltungsname/{namensteil}")]

  [System.Web.Http.ActionName("Veranstaltungsname")]
  public IQueryable<Veranstaltung> GetVeranstaltungen(string namensteil)
  {
   return db.VeranstaltungsSet.Where(x => x.Name.Contains(namensteil));
  }


  //// GET api/VeranstaltungAPI/Datum
  /// Bsp: http://localhost:44681//api/VeranstaltungAPI/Datum/2014-02-15
  //[System.Web.Http.ActionName("Datum")]
  [AcceptVerbs("X-Datum", "X-Date", "Patch")]
  [HttpPatch]
  [Route("api/VeranstaltungAPI/Datum/{datum}")]
  public IQueryable<Veranstaltung> GetVeranstaltungen(DateTime datum)
  {
   var veranstaltungen = db.VeranstaltungsSet.Where(x => x.Datum == datum);
   return veranstaltungen;
  }

  // PUT api/VeranstaltungAPI/5
  public IHttpActionResult PutVeranstaltung(int id, Veranstaltung veranstaltung)
  {
   if (!ModelState.IsValid)
   {
    return BadRequest(ModelState);
   }

   if (id != veranstaltung.ID)
   {
    return BadRequest();
   }

   db.Entry(veranstaltung).State = EntityState.Modified;

   try
   {
    db.SaveChanges();
   }
   catch (DbUpdateConcurrencyException)
   {
    if (!VeranstaltungExists(id))
    {
     return NotFound();
    }
    else
    {
     throw;
    }
   }

   return StatusCode(HttpStatusCode.NoContent);
  }

  // POST api/VeranstaltungAPI
  [ResponseType(typeof(Veranstaltung))]
  public IHttpActionResult PostVeranstaltung(Veranstaltung veranstaltung)
  {
   if (!ModelState.IsValid)
   {
    return BadRequest(ModelState);
   }

   db.VeranstaltungsSet.Add(veranstaltung);
   db.SaveChanges();

   return CreatedAtRoute("DefaultApi", new { id = veranstaltung.ID }, veranstaltung);
  }

  // DELETE api/VeranstaltungAPI/5
  [ResponseType(typeof(Veranstaltung))]
  public IHttpActionResult DeleteVeranstaltung(int id)
  {
   Veranstaltung veranstaltung = db.VeranstaltungsSet.Find(id);
   if (veranstaltung == null)
   {
    return NotFound();
   }

   db.VeranstaltungsSet.Remove(veranstaltung);
   db.SaveChanges();

   return Ok(veranstaltung);
  }

  protected override void Dispose(bool disposing)
  {
   if (disposing)
   {
    db.Dispose();
   }
   base.Dispose(disposing);
  }

  private bool VeranstaltungExists(int id)
  {
   return db.VeranstaltungsSet.Count(e => e.ID == id) > 0;
  }



  // GET api/VeranstaltungAPI
  //public IQueryable<Veranstaltung> GetVeranstaltungsSet2()
  //{
  // return db.VeranstaltungsSet;
  //}

  // GET api/VeranstaltungAPI/5

  [Route("api/VeranstaltungAPI/{id}/Teilnehmer")]
  public IHttpActionResult GetTeilnehmer(int id)
  {
   Veranstaltung veranstaltung = db.VeranstaltungsSet.Include(x => x.Teilnehmerliste).SingleOrDefault(x => x.ID == id);
   if (veranstaltung == null)
   {
    return NotFound();
   }

   return Ok(veranstaltung.Teilnehmerliste);
  }

  [Route("api/VeranstaltungAPI/{vid}/Teilnehmer/{tid}")]
  public HttpResponseMessage PostTeilnehmer(int vid, int tid)
  {
   var antwort = new HttpResponseMessage();

   Veranstaltung veranstaltung = db.VeranstaltungsSet.Include(x => x.Teilnehmerliste).SingleOrDefault(x => x.ID == vid);
   if (veranstaltung == null)
   {
    antwort.StatusCode = HttpStatusCode.NotFound;
    antwort.Content = new StringContent("Veranstaltung nicht gefunden");
    return antwort;
   }
   Teilnehmer teilnehmer = db.TeilnehmerSet.Find(tid);
   if (teilnehmer == null)
   {
    antwort.StatusCode = HttpStatusCode.NotFound;
    antwort.Content = new StringContent("Teilnehmer nicht gefunden");
    return antwort;
   }

   veranstaltung.Teilnehmerliste.Add(teilnehmer);
   db.SaveChanges();

   antwort.StatusCode = HttpStatusCode.OK;
   antwort.Content = new StringContent("Teilnehmer " + teilnehmer.Name + " zu Veranstaltung " + veranstaltung.Name + " hinzugefügt");

   return antwort;
  }
 }

}