﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web.Http;
using System.Web.Http.OData.Builder;
using System.Web.Http.Tracing;
using Newtonsoft.Json;
using System.Web.Http.OData.Builder;
using Modell;

namespace Website
{
 public static class WebApiConfig
 {
  public static void Register(HttpConfiguration config)
  {
   // Web API configuration and services

   // Web API routes
   config.MapHttpAttributeRoutes();
   //config.EnableQuerySupport();
   
   config.Routes.MapHttpRoute(
       name: "DefaultApi",
       routeTemplate: "api/{controller}/{id}", // {action}/

       defaults: new { id = RouteParameter.Optional }
   );

   ODataConventionModelBuilder builder = new ODataConventionModelBuilder();
   builder.EntitySet<Veranstaltung>("VeranstaltungOData");
   builder.EntitySet<Teilnehmer>("Teilnehmer");
   config.Routes.MapODataRoute("odata", "odata", builder.GetEdmModel());

   config.EnableSystemDiagnosticsTracing();

   var formatter = GlobalConfiguration.Configuration.Formatters.JsonFormatter;
   formatter.UseDataContractJsonSerializer = false;
   formatter.SerializerSettings.DateTimeZoneHandling =
                              Newtonsoft.Json.DateTimeZoneHandling.Local;
   formatter.SerializerSettings.DateFormatHandling =
                              Newtonsoft.Json.DateFormatHandling.IsoDateFormat;
   //jf.SerializerSettings.DateFormatHandling = 
   //Newtonsoft.Json.DateFormatHandling.MicrosoftDateFormat;
   formatter.SerializerSettings.Formatting = Newtonsoft.Json.Formatting.Indented;
   formatter.SerializerSettings.PreserveReferencesHandling = PreserveReferencesHandling.All;

   // XmlSerializer = true
   // false = DataContractSerializer
   GlobalConfiguration.Configuration.Formatters.XmlFormatter.UseXmlSerializer = false;

   config.Services.Replace(typeof(ITraceWriter), new WebsiteTraceWriter());




  }
 }
}
