﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.ComponentModel.DataAnnotations;
using System.Runtime.Serialization;

namespace Modell
{
 //[DataType(DataType.MultilineText)]
 //[DataType(DataType.Password)]
 //[DisplayFormat(NullDisplayText = "(null value)")]
 //[DataType(DataType.EmailAddress)]
 //[AdditionalMetadata("autofocus", true)]
 [DataContract(IsReference = true)]
 public class Veranstaltung
 {
  [DataMember]
  public int ID { get; set; }
  [DataMember]
  public string Name { get; set; }
  [DataMember]
  public DateTime Datum { get; set; }
  [DataMember]
  public virtual List<Teilnehmer> Teilnehmerliste { get; set; }
 }

 public enum Anrede
 {
  Herr,
  [Description("Herr Dr")]
  HerrDr,
  Frau,
  [Description("Frau Dr")]
  FrauDr
 }

 [DataContract(IsReference = true)]
 public class Teilnehmer
 {
  [DataMember]
  public int ID { get; set; }
  [DataMember]

  public Anrede Anrede { get; set; }
  [Required(ErrorMessage = "Name ist Pflichtfeld!")]
  [StringLength(50)]
  [RegularExpression(".* .*", ErrorMessage = "Eingabe muss mindestens aus Vorname, einem Leerzeichen und Nachname bestehen!")]
  [DataMember]

  public string Name { get; set; }
  [Required(ErrorMessage = "E-Mail ist Pflichtfeld!")]
  [EmailAddress(ErrorMessage = "Keine gültige E-Mail-Adresse")]

  [DataMember]
  public string EMail { get; set; }
  [DisplayFormat(ApplyFormatInEditMode = true, DataFormatString = "{0:dd.MMM.yyyy}")]
  [DataType(DataType.Date)]
  public Nullable<DateTime> Geburtstag { get; set; }

  [DataMember]
  [DefaultValue(1)]
  [Range(0, 3, ErrorMessage = "Sie dürfen maximal 3 Personen mitbringen")]
  public byte AnzahlBegleitpersonen { get; set; }
  [DataMember]
  public bool Vortragender { get; set; }
  [DataMember]
  public virtual Veranstaltung Veranstaltung { get; set; }
 }
}
