﻿using Modell;
using System;
using System.Collections.Generic;
using System.Net.Http;
using System.Net.Http.Headers;

namespace Konsolenclient
{
 class Program
 {
  static void Main(string[] args)
  {
   Console.WriteLine("Start...");
   LadeUndErgaenzeTeilnehmer(1, 4);
   Console.WriteLine("Warte... (Beenden mit Tastendruck)");
   Console.ReadLine();
  }

  public async static void LadeUndErgaenzeTeilnehmer(int veranstaltungdId, int TeilnehmerID)
  {
   // Festlegen der URL der Webdienst
   string BasisURL = "http://server/api/VeranstaltungAPI/";
   string url_Abruf1 = BasisURL + veranstaltungdId;
   string url_Abruf2 = url_Abruf1 + "/Teilnehmer";
   string url_Abruf3 = url_Abruf2 + "/" + TeilnehmerID;

   using (var client = new HttpClient())
   {
    client.DefaultRequestHeaders.Accept.Add(new MediaTypeWithQualityHeaderValue("text/xml"));

    // Schritt 1: Abrufen der Veranstaltungsdaten für eine Veranstaltung
    var antwort1 = await client.GetAsync(url_Abruf1);
    Veranstaltung veranstaltung = await antwort1.Content.ReadAsAsync<Veranstaltung>();
    Console.WriteLine("Veranstaltung {0}: {1} am {2}:", veranstaltung.ID, veranstaltung.Name, veranstaltung.Datum);

    // Schritt 2: Abrufen der Teilnehmerdaten für eine Veranstaltung
    var antwort2 = await client.GetAsync(url_Abruf2);
    IEnumerable<Teilnehmer> teilnehmerListe = await antwort2.Content.ReadAsAsync<IEnumerable<Teilnehmer>>();
    foreach (var teilnehmer in teilnehmerListe)
    {
     Console.WriteLine("Teilnehmer {0}: {1}", teilnehmer.ID, teilnehmer.Name);
    }

    // Schritt 3: Ergänze einen Teilnehmer
    HttpContent content = new StringContent("");
    var antwort3 = await client.PostAsync(url_Abruf3, content);
    var ergebnis = await antwort3.Content.ReadAsStringAsync();
    Console.WriteLine(ergebnis);
   }
  }
 }
}