﻿<%@ Control Language="C#" Inherits="System.Web.Mvc.ViewUserControl" %>
<script runat="server">
    private List<System.Web.Mvc.SelectListItem> TriStateValues {
        get {
            return new List<System.Web.Mvc.SelectListItem> {
                new System.Web.Mvc.SelectListItem { Text = "Not Set", Value = String.Empty, Selected = !Value.HasValue },
                new System.Web.Mvc.SelectListItem { Text = "True", Value = "true", Selected = Value.HasValue && Value.Value },
                new System.Web.Mvc.SelectListItem { Text = "False", Value = "false", Selected = Value.HasValue && !Value.Value },
            };
        }
    }
    private bool? Value {
        get {
            if (ViewData.Model == null) {
                return null;
            }
            return Convert.ToBoolean(ViewData.Model, System.Globalization.CultureInfo.InvariantCulture);
        }
    }
</script>
<% if (ViewData.ModelMetadata.IsNullableValueType) { %>
    <%= Html.DropDownList("", TriStateValues, ViewData) %>
<% } else { %>
    <%= Html.CheckBox("", Value ?? false, ViewData) %>
<% } %>