﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.ComponentModel.DataAnnotations;

namespace Modell
{
 //[DataType(DataType.MultilineText)]
 //[DataType(DataType.Password)]
 //[DisplayFormat(NullDisplayText = "(null value)")]
 //[DataType(DataType.EmailAddress)]
 //[AdditionalMetadata("autofocus", true)]
 public class Veranstaltung
 {
  public int ID { get; set; }

  public string Name { get; set; }

  public DateTime Datum { get; set; }

  public virtual List<Teilnehmer> Teilnehmerliste { get; set; }
 }

 public enum Anrede
 {
  Herr,
  [Description("Herr Dr")]
  HerrDr,
  Frau,
  [Description("Frau Dr")]
  FrauDr
 }

 public class Teilnehmer
 {
  public int ID { get; set; }
  public Anrede Anrede { get; set; }
  [Required(ErrorMessage = "Name ist Pflichtfeld!")]
  [StringLength(50)]
  [RegularExpression(".* .*", ErrorMessage = "Eingabe muss mindestens aus Vorname, einem Leerzeichen und Nachname bestehen!")]
  public string Name { get; set; }
  [Required(ErrorMessage = "E-Mail ist Pflichtfeld!")]
  [EmailAddress(ErrorMessage = "Keine gültige E-Mail-Adresse")]
  public string EMail { get; set; }
  [DisplayFormat(ApplyFormatInEditMode = true, DataFormatString = "{0:dd.MMM.yyyy}")]
  [DataType(DataType.Date)]
  public Nullable<DateTime> Geburtstag { get; set; }

  [DefaultValue(0)]
  [Range(0,3, ErrorMessage="Sie dürfen maximal 3 Personen mitbringen")]
  public byte AnzahlBegleitpersonen { get; set; }
  public bool Vortragender { get; set; }
  public virtual Veranstaltung Veranstaltung { get; set; }
 }
}
