/*
 * obd2.h
 *
 *  Created on: 07.11.2013
 *      Author: mu
 */

#ifndef OBD2_H_
#define OBD2_H_

/* --Standard-Schnittstelle. */
#include <stdint.h>
#include <cstring>
#include <iostream>

/* --Lokales Include. */
#include "canbus.h"

/* --SocketCAN-Schnittstelle. */
#include <linux/can/isotp.h>

/* --Diagnose-Klasse. */
class OnBoardDiagnostics : public ControllerAreaNetwork {
public:

	/* --Konstruktur. */
	OnBoardDiagnostics();

	/* --Destruktur. */
	~OnBoardDiagnostics();

	/* --ISO-TP Konfiguration. */
	bool configure(const char* device ="can0");

	/* --Anfrage versenden. */
	bool request(uint8_t sid, uint8_t pid);

	/* --Antwort erfragen. */
	bool receive(uint8_t& sid, uint8_t& pid, int32_t& nbytes);

	/* --Lesender Zugriff auf den Puffer. */
	const uint8_t* buffer() const;

	/* --Diagnosedate abfrage (SID: 0x01). */
	bool diagnose(uint8_t pid, int32_t expected, uint8_t* parameter);

private:

	/* --Socket-ISOTP-Optionen. */
    can_isotp_options options;

	/* --Datenpuffer für ISO TP Nachricht. */
	enum { ISOTP_BUFSIZE = 4096 };
	uint8_t buf[ISOTP_BUFSIZE];

};

inline const uint8_t* OnBoardDiagnostics::buffer() const {
	return buf;
}


/* --OBD2 Parameterinformationen. */
struct ParameterInfo {

	enum Unit { NO_UNIT =1, PERCENTAGE, CELSIUS, KM_PER_HOUR, RPM, SECONDS };

	/* --Attribute. */
	uint8_t	pid;
	Unit physical;
	const char* textual;
	double minvalue;
	double maxvalue;
	uint8_t nbytes;

	/* --Rohwert in physikalische Einheit umrechnen. */
	double toPhysical(const uint8_t* bytes) const;

};

#endif /* OBD2_H_ */
