/*
 * obd2.cpp
 *
 *  Created on: 07.11.2013
 *      Author: mu
 */

#include "obd2.h"

OnBoardDiagnostics::OnBoardDiagnostics():ControllerAreaNetwork(),options() {
	/* --Socket-Optionen setzen. */
	type=SOCK_DGRAM;
	protocol=CAN_ISOTP;
}

OnBoardDiagnostics::~OnBoardDiagnostics() {}

bool OnBoardDiagnostics::configure(const char* device) {
	/* --Basisklasse konfigurieren. */
	bool retvalue=ControllerAreaNetwork::configure(device);
	/* --ISO TP spezifische Ergänzungen. */
	if (retvalue) {
		/* --Funktionale Adresse 0x7df. */
		address.can_addr.tp.tx_id=0x7df;
		address.can_addr.tp.rx_id=0x7e8;

		/* --Auffüllen auf 8 Bytes pro ISO-TP-Nachricht. */
		options.flags=CAN_ISOTP_TX_PADDING;
		options.txpad_content=0x00;

		/* --ISO-TP-Optionen setzen. */
		if (setsockopt(descriptor,SOL_CAN_ISOTP,CAN_ISOTP_OPTS,&options,sizeof(options))==-1) {
			std::cerr << "ISO-TP Optionen konnten nicht gesetzt werden." << std::endl;
			finalize();
			return false;
		}
	}
	return retvalue;
}

bool OnBoardDiagnostics::request(uint8_t sid, uint8_t pid) {
	bool retvalue=true;
	/* --ISO TP-Nachricht erstellen. */
	buf[0]=sid;
	buf[1]=pid;
	/* --Schreibe in Socket. */
	if (write(descriptor,buf,2)!=2) {
		std::cerr << "Schreiben in Socket ist fehlgeschlagen." << std::endl;
		retvalue=false;
	}
	return retvalue;
}

bool OnBoardDiagnostics::receive(uint8_t& sid, uint8_t& pid, int32_t& nbytes) {
	/* --Lese vom Socket. */
    nbytes=read(descriptor,buf,ISOTP_BUFSIZE);

    if (nbytes==-1) {
    	std::cerr << "Lesen vom Socket ist fehlgeschlagen." << std::endl;
    	return false;
    }

    /* --Überprüfe eingegangene Nachricht. */
    if (nbytes<3) {
    	std::cerr << "Antwort hat falsches Format." << std::endl;
    	return false;
    }

    sid=buf[0];
    pid=buf[1];

	return true;
}

bool OnBoardDiagnostics::diagnose(uint8_t pid, int32_t expected, uint8_t* parameter) {
	uint8_t rsid=0,rpid=0;
	int32_t nbytes=0;
	bool retvalue=false;

	/* --Anfrage versenden und Antwort empfangen. */
	if (request(0x01,pid) && receive(rsid,rpid,nbytes)) {
		/* --Richtige Antwort und genügend Bytes empfangen? */
		if (pid==rpid && (nbytes-2)==expected) {
			/* --Kopiere Ergebnis zur Weiterverarbeitung. */
			for(int32_t i=0;i<nbytes;i++)
				parameter[i]=buffer()[i+2];
			retvalue=true;
		}
	}
	return retvalue;
}

double ParameterInfo::toPhysical(const uint8_t* bytes) const {
	uint32_t raw=0,shift=nbytes*8;
	for(int32_t i=0;i<nbytes;i++) {
		raw<<=8;
		raw+=bytes[i];
	}
	/* --Gültige Einheit? */
	if (physical!=NO_UNIT)
		return minvalue+(maxvalue-minvalue)*raw/(1<<shift);
	return raw;
}


