/*
 * canbus.h
 *
 *  Created on: 10.11.2013
 *      Author: mu
 */

#ifndef CANBUS_H_
#define CANBUS_H_

/* --Standard-Schnittstelle. */
#include <stdint.h>
#include <cstring>
#include <iostream>

/* --Socket-Schnittstelle. */
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <net/if.h>

/* --SocketCAN-Schnittstelle. */
#include <linux/can.h>

class ControllerAreaNetwork {
public:

	ControllerAreaNetwork();
	virtual ~ControllerAreaNetwork();

	virtual bool configure(const char* device ="can0");
	virtual bool initialize();
	virtual bool finalize();

	/* --Lesen eines CAN-Datentelegramm mit Zeitstempel. */
	bool receive(can_frame& frame, timeval& timestamp);
	/* --Schreiben eines CAN-Datentelegramms. */
	bool post(const can_frame& frame);

protected:

	/* --Socket-Descriptor. */
	int32_t descriptor;

	/* --Socket-HW-Gerät. */
	ifreq interface;

	/* --Adressinformationen. */
	sockaddr_can address;

	/* --Socket-Typ, -Protokoll. */
	int32_t type;
	int32_t protocol;

};


#endif /* CANBUS_H_ */
