/*
 * canbus.cpp
 *
 *  Created on: 10.11.2013
 *      Author: mu
 */

#include "canbus.h"

ControllerAreaNetwork::ControllerAreaNetwork():
	descriptor(-1),interface(),address(),type(SOCK_RAW),protocol(CAN_RAW) {}

ControllerAreaNetwork::~ControllerAreaNetwork() { finalize(); }

bool ControllerAreaNetwork::configure(const char* device) {
	/* --Socket erzeugen: Protokollfamilie, Verbindungstyp, Protokoll. */
	descriptor=socket(PF_CAN,type,protocol);
	if (descriptor==-1) {
		std::cerr << "Socket konnte nicht erzeugt werden." << std::endl;
		return false;
	}

	/* --HW-Schnittstelle. */
	strcpy(interface.ifr_name,device);

	/* --HW-Adresse ermitteln. */
	if (ioctl(descriptor,SIOGIFINDEX,&interface)==-1) {
		std::cerr << "Gerät konnt nicht gefunden werden." << std::endl;
		close(descriptor);
		return false;
	}

	/* --Setze die Adressinformationen. */
	address.can_family=AF_CAN;
	/* --Übernehme Gerätekennung. */
	address.can_ifindex=interface.ifr_ifindex;

	return true;
}



bool ControllerAreaNetwork::ControllerAreaNetwork::initialize() {
	/* --Socket mit HW verbinden. */
	if (bind(descriptor,(sockaddr*)&address,sizeof(address))!=0) {
		std::cerr << "Socket konnte nicht verbunden werden." << std::endl;
		finalize();
		return false;
	}
	return true;
}



bool ControllerAreaNetwork::ControllerAreaNetwork::finalize() {
	bool retvalue=true;
	/* --Socket schliessen. */
	if (descriptor!=-1) {
		retvalue=(close(descriptor)!=-1 ? true : false);
		descriptor=-1;
	}
	return retvalue;
}

bool ControllerAreaNetwork::receive(can_frame& frame, timeval& timestamp) {
	/* --Lese Daten vom Socket. */
	int32_t nbytes=read(descriptor,&frame,sizeof(can_frame));

	/* --Lesezugriff erfolgreich? */
	if (nbytes==-1) {
		std::cerr << "Lesen vom Socket ist fehlgeschlagen." << std::endl;
		return false;
	}

	/* --Vollständiges Datentelegramm empfangen? */
	if (nbytes<(int32_t)sizeof(can_frame)) {
		std::cerr << "CAN Datentelegramm ist unvollständig." << std::endl;
		return false;
	}

	/* --Bestimme Zeitstempel vom letzten Datentelegramm. */
	if (ioctl(descriptor, SIOCGSTAMP, &timestamp)!=0) {
		std::cerr << "Zeitstempel konnte nicht ermittelt werden." << std::endl;
		return false;
	}

	return true;
}

bool ControllerAreaNetwork::post(const can_frame& frame) {
	/* --Schreibe Daten in den Socket. */
	int32_t nbytes = write(descriptor,&frame,sizeof(can_frame));

	/* --Alles verschickt? */
	if (nbytes!=(int32_t)sizeof(can_frame)) {
		std::cerr << "CAN Datentelegramm unvollständig versendet." << std::endl;
		return false;
	}

	return true;
}


