﻿var bl = null;
var basePolyline = null;
var basePolylineXY = null;

var map = null;

var GeoMath = {
    sqrLength: function (v) {
        return(v[0]*v[0]+v[1]*v[1]);
    },
    sqrDistance: function (p1, p2) {
        var ergebnis = (p1[0] - p2[0]) * (p1[0] - p2[0]) + (p1[1] - p2[1]) * (p1[1] - p2[1]);
        return ergebnis;
    },
    distance: function(p1,p2) {
        return(Math.sqrt(this.sqrDistance(p1,p2)));
    },
    distanceLinePoint2: function (l1, l2, p) {
        var v1 = [p[0] - l1[0], p[1] - l1[1]];
        var v2 = [l2[0] - l1[0], l2[1] - l1[1]];
        var v2l = Math.sqrt(GeoMath.sqrLength(v2));
        var v21 = [v2[0]/v2l,v2[1]/v2l];
        return (v1[0] * v21[0] + v1[1] * v21[1]);
    },
    distanceLinePoint: function (l1, l2, p) {
        return (Math.sqrt(this.sqrDistanceLinePoint(l1,l2,p)));
    },
    sqrDistanceLinePoint: function (l1, l2, p) {
        var v1 = [p[0] - l1[0], p[1] - l1[1]];
        var v2 = [l2[0] - l1[0], l2[1] - l1[1]];
        var k = this.sqrLength(v2);
        var c = Math.sqrt(this.sqrLength(v2));
        var dot = (v1[0] * v2[0] + v1[1] * v2[1]) / Math.sqrt(this.sqrLength(v2));
        return (this.sqrLength(v1) - dot * dot);
    },
    radiansFactor: Math.PI/180,
    toRadians: function (grad) {
        return grad * this.radiansFactor;
    },
    erdradius : 6378137, //Meter
    latLonToXY: function (latLon) {//Merctor-Projektion
        var ergebnis = [];
        ergebnis.push(this.toRadians(latLon[1])*this.erdradius);
        var sinus = Math.sin(this.toRadians(latLon[0]));
        ergebnis.push(0.5 * Math.log((1 + sinus) / (1 - sinus)) * this.erdradius);
       // var test = this.LatLonToMercator(latLon[0], latLon[1]);
        return ergebnis;
    },
    LatLonToMercator : function (lat, lon) {
        var rMajor = 6378137; //Equatorial Radius, WGS84     
        var shift  = Math.PI * rMajor;     
        var x      = lon * shift / 180;     
        var y      = Math.log(Math.tan((90 + lat) * Math.PI / 360)) / (Math.PI / 180);     
        y = y * shift / 180;       
        return {'X': x, 'Y': y}; }
}

function convertLatLonToXY(polyline) {
    var ergebnis = []; 
    for (var i = 0; i < polyline.length; i++) {
        ergebnis.push(GeoMath.latLonToXY(polyline[i]));
    }
    return ergebnis;
}

function convertIndexToLatLon(indexPolyline, latLonPolyline) {
    var ergebnis = [];
    for (var i = 0; i < indexPolyline.length; i++) {
        ergebnis.push(latLonPolyline[indexPolyline[i]]);
    }
    return ergebnis;
}

function initialize() {
    initializeMap();

    readOpenStreetMapData();

    //initializeUI();
}

function initializeMap() {
    map = L.map('map', {
              center: [49.02,12.10],
              zoom: 11,
              zoomControl: false
    });

    // add an OpenStreetMap tile layer
    L.tileLayer('http://{s}.tile.osm.org/{z}/{x}/{y}.png', {
        attribution: '&copy; <a href="http://osm.org/copyright">OpenStreetMap</a> contributors' })
       .addTo(map);

    L.control.zoom({position:'topright'})
        .addTo(map);

    // add a marker in the given location, attach some popup content to it and open the popup
    //L.marker([51.5, -0.09]).addTo(map)
    //    .bindPopup('A pretty CSS3 popup. <br> Easily customizable.')
    //    .openPopup();
}

function initializeUI() {
    //Bundesland
    var output = '';
    for (var bundesland in bl) {
        output += '<option>' + bundesland + '</option>';
    }
    $("#bundesland").append(output).select('refresh');
}

function readOpenStreetMapData() {
    $.mobile.showPageLoadingMsg();;
    if ( typeof bljson == 'undefined') {
        $.ajax({
            type: "GET",
            url: "bl.json",
            dataType: "json"
        })
        .done(function (x) {
            $.mobile.hidePageLoadingMsg();
            bl = x;
            initializeUI();
        })
        .fail(function (jqXHR, textStatus, errorThrown) {
            alert("An error occurred while processing XML file." + errorThrown);
        });
    } else {
        bl = bljson;
        initializeUI();
    }
}



function getPolylineArray(name) {
    basePolyline = bl[name];
    basePolylineXY = convertLatLonToXY(basePolyline);

    // create a red polyline from an arrays of LatLng points
    var polylineInMap = L.polyline(basePolyline, { color: 'red' }).addTo(map);

    // zoom the map to the polyline
    map.fitBounds(polylineInMap.getBounds());

    $('#orginalanzahl').html('Orginalzahl ' + bl[name].length);
}

var newPolylineInMap = null;
var algorithmus = null;

function setAlgorithmus(name) {
    if (basePolyline == null) return;
    algorithmus = name;

    switch (algorithmus) {
        case "NthPoint":
            $('#parameterlabel').html('Prameter (n-ter Punkt)');
            $('#parameter').val(250);
            break;
        case "RadialDistance":
            $('#parameterlabel').html('Prameter (Mindestabstand)');
            $('#parameter').val(5000);
            break;
        case "ReumannWitkam":
            $('#parameterlabel').html('Prameter (Mindestabstand)');
            $('#parameter').val(2500);
            break;
        case "Lang":
            $('#parameterlabel').html('Prameter (Mindestabstand)');
            $('#parameter').val(2000);
        case "DouglasPeucker":
            $('#parameterlabel').html('Prameter (Abstand)');
            $('#parameter').val(1500);
        default:
            return;
    }
}

//Zusätzliche Algorithmen
//Random Point - Punkte werden zufällig ausgewählt

function doAlgorithmus(name) {
    
    var newPolyline = null;
    var parameter = parseInt($('#parameter').val());

    switch(algorithmus)
    {
        case "NthPoint":
            newPolyline = doNthPoint(basePolylineXY,parameter);
            break;
        case "RadialDistance":
            newPolyline = doRadialDistance(basePolylineXY, parameter);
            break;
        case "ReumannWitkam":
            newPolyline = doReumannWitkam(basePolylineXY, parameter);
            break;
        case "Lang":
            newPolyline = doLang(basePolylineXY, parameter);
            break;
        case "DouglasPeucker":
            newPolyline = doDouglasPeucker(basePolylineXY,0,basePolylineXY.length-1,parameter);
            break;
        default:
            return;
    }

    var newLatLonPolyline = convertIndexToLatLon(newPolyline, basePolyline);
    if (newPolylineInMap == null) { 
        newPolylineInMap = L.polyline(newLatLonPolyline, { color: 'blue' }).addTo(map);
    } else {
        newPolylineInMap.setLatLngs(newLatLonPolyline);
    }

    $('#simplifyanzahl').html('Vereinfacht ' + newPolyline.length);

    var error = sumAbweichung(newPolyline, basePolylineXY)/1000000;
    $('#abweichung').html('Abweichung ' + error);
    AddInfo(algorithmus, parameter, basePolyline.length, newPolyline.length, error);
}

function AddInfo(algorithmus, parameter, orginalanzahl, reduzierteAnzahl, abweichung){
    $('#info-table-body').append('<tr><td>'+algorithmus+'</td><td>'
                                           + parameter + '</td><td>'
                                           + orginalanzahl + '</td><td>'
                                           + reduzierteAnzahl + '</td ><td>'
                                           +abweichung+'</td></tr>');
}

function doNthPoint(polyline, n) {
    var ergebnis = [];

    for (var i = 0; i < polyline.length; i=i+n) {
        ergebnis.push(i);
    }

    ergebnis.push(polyline.length - 1); //letzen Punkt hinzufügen
    return (ergebnis);
}

function doRadialDistance(polyline, radialDistance) {
    var ergebnis = [];
    var sqrDistance = radialDistance * radialDistance;

    var lastPoint = polyline[0];
    ergebnis.push(0);

    for (var i = 1; i < polyline.length; i++) {
        if (sqrDistance < GeoMath.sqrDistance(lastPoint, polyline[i])) {
            lastPoint = polyline[i];
            ergebnis.push(i);
        }
    }

    if (ergebnis[ergebnis.length - 1] != polyline.length) {
        ergebnis.push(polyline.length-1);
    }

    return ergebnis;
}



function doReumannWitkam(polyline, segmentDistance) {
    var ergebnis = [];
    var sqrDistance = segmentDistance * segmentDistance;

    var firstPoint = 0;
    var lastPoint = 1;

    ergebnis.push(0);

    for (var i = 2; i < polyline.length - 1; i++) {
        if (sqrDistance < GeoMath.sqrDistanceLinePoint(polyline[firstPoint], polyline[lastPoint], polyline[i])) {
            //Punkt ausserhalb Abstand
            ergebnis.push(i - 1);
            firstPoint = i - 1;
            lastPoint = i;
        }
    }

    if (ergebnis[ergebnis.length - 1] != polyline.length) {
        ergebnis.push(polyline.length - 1);
    }

    return ergebnis;
}

function doLang(polyline, segmentDistance) {
    var ergebnis = [];
    var lookAhead = 256;
    var sqrDistance = segmentDistance * segmentDistance;

    var firstPoint = 0;
    var lastPoint = 0;

    ergebnis.push(0);

    for (var i = lookAhead; i < polyline.length;) {
        firstPoint = i - lookAhead;
        for (var j = lookAhead; j > 2; j = j - 1) {
            lastPoint = firstPoint + j;
            var punktAusserhalbAbstand = false
            for (var k = firstPoint+1; k < lastPoint; k++) {
                if (sqrDistance < GeoMath.sqrDistanceLinePoint(polyline[firstPoint], polyline[lastPoint], polyline[k])) {
                    //Punkt ausserhalb Abstand
                    punktAusserhalbAbstand = true;
                    break;
                }
            }
            if (!punktAusserhalbAbstand) {
                ergebnis.push(lastPoint);
                i = lastPoint + lookAhead;
                break;
            }
        }
        if (punktAusserhalbAbstand) {
            ergebnis.push(firstPoint + 1);
            i = firstPoint + 1 + lookAhead;
        }
    }

    if (ergebnis[ergebnis.length - 1] != polyline.length) {
        ergebnis.push(polyline.length - 1);
    }

    return ergebnis;
}

function doDouglasPeucker(polyline,start,end,epsilon){
    var result = [];
    
    var maxDistance = getMaxDistance(polyline,start,end);
 
    if (maxDistance.dmax >= epsilon){
        var result1 = doDouglasPeucker(polyline,start,maxDistance.index, epsilon);
        var result2 = doDouglasPeucker(polyline,maxDistance.index,end, epsilon);
 
        result = result1.slice(0,result1.length-1).concat(result2);
    } else {
        result.push(start);
        result.push(end);
    }
 
    return result;
}

function getMaxDistance(polyline,start,end){
    var ergebnis = [];
    ergebnis.dmax = 0;
    ergebnis.index = 0;

    //Start and end the same
    var isSimple = (polyline[start][0]==polyline[end][0]&&polyline[start][1]==polyline[end][1]);

    var d = -1;

    for (i = start+1; i<end; i++){
        if(!isSimple){
            d = GeoMath.disctanceLinePoint(polyline[start], polyline[end],polyline[i])
        }else{
            d = GeoMath.distance(polyline[start],polyline[i]);
        }
        if (d > ergebnis.dmax) {
            ergebnis.index = i;
            ergebnis.dmax = d;
        }
    }

   return ergebnis;
}


function sumAbweichung(newPolyline, polyline) {
    var ergebnis = 0;
    for (var i = 1; i < newPolyline.length; i++) {//Liniensegment
        var l0 = newPolyline[i - 1];
        var l1 = newPolyline[i];
        for (var j = l0 + 1; j < l1; j++) {//Entfallene Punkte
            var distance = GeoMath.distanceLinePoint(polyline[l0], polyline[l1], polyline[j]);
            if (!isNaN(distance)) {
                ergebnis = ergebnis + distance;
            }
        }
    }
    return (ergebnis);
}