﻿var $xml = null;
var polyline = null;

var GeoMath = {
    sqrDistanceSimple: function (p1, p2) {
        return (p1[0] - p2[0]) ^ 2 + (p1[1] - p2[2]) ^ 2;
    }
}
function readOpenStreetMapData() {
    $.ajax({type: "GET", 
            url: "bl.xml",
            dataType: "xml"
    })
    .done( function ($x) {
               $xml = $x;
               getPolylineArray($xml, 'Bayern');
          })
    .fail(function (jqXHR, textStatus, errorThrown) {
              alert("An error occurred while processing XML file." + errorThrown);
          });
    
}

function getPolylineArray($xml,name) {
    var $land = $("relation:has(tag[k='name'][v='Bayern'])", $xml);

    var ways = [];

    var $members = $("member[type='way'][role='outer']", $land);


    var $wayslider = $("#wayslider");
    $wayslider.attr("min", 1);
    $wayslider.attr("max", $members.length);
    var numberOfWay = 0;

    $members.each(function (i, member) {
        var newWay = [];
        numberOfWay++;
        console.log(numberOfWay);

        var $way = $("way[id='" + $(member).attr("ref") + "']",$xml);
        var $nodes = $("nd", $way);
        var numberOfNodes = 0;

        $nodes.each(function (i, nd) {
            var node = $("node[id='" + $(nd).attr("ref") + "']:first",$xml);
            var cords = [parseFloat(node.attr("lon")), parseFloat(node.attr("lat"))];
            newWay.push(cords);
            numberOfNodes++;
            console.log(numberOfNodes);
        });
        ways.push(newWay);
    });

    polyline = getPolylineFromWays();
}

function getPolylineFromWays(ways) {
    var j = 0;
    var w = ways[j];
    var result = [];

    while (w != null) {
        for ( i in w) {
            result.push(i);
        };
        
        var lastNode = w[w.Count()-1];
        ways[j] = null;

        var minDistance = 10000;
        var minWay = -1;

        for (k = j + 1; k < ways.Count() ; k++) {
            if (ways[k]!=null) {
                var distance = GeoMath.sqrDistanceSimple(lastNode, ways[k][0]);
                if (distance < minDistance) {
                    minDistance = distance;
                    minWay = k;
                }
            }
        }

        if (minWay > -1) {
            j = minWay;
            w = ways[j];
        } else {
            w = null;
        }
    }

    return result;
}
    