/**
 * @file LogoRotate.hpp
 */

/*
 * Copyright (C) Gemfony scientific UG (haftungsbeschraenkt)
 *
 * Contact: contact [at] gemfony (dot) com
 *
 * This file is part of the LogoRotate program.
 *
 * LogoRotate is free software: you can redistribute and/or modify it under
 * the terms of version 3 of the GNU Affero General Public License
 * as published by the Free Software Foundation.
 *
 * LogoRotate is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with the Geneva library. If not, see <http://www.gnu.org/licenses/>.
 *
 * For further information on Gemfony scientific, visit http://www.gemfony.com
 */

#ifndef LOGOROTATE_HPP_
#define LOGOROTATE_HPP_

#define __CL_ENABLE_EXCEPTIONS

#include <stdio.h>
#include <string>
#include <sstream>
#include <iostream>
#include <fstream>
#include <vector>
#include <cmath>

#include "CL/cl.hpp"

// Boost files go here
#include <boost/lexical_cast.hpp>
#include <boost/bind.hpp>

// The image file
#include "ixlogo.hpp"

/*******************************************************************************/
/**
 * Rotates a logo in a number of steps, emitting the rotated image after
 * each step.
 */
class LogoRotate {
public:
  LogoRotate(const std::string&);
  ~LogoRotate();

  std::string rotate(const float&);

private:
  LogoRotate(); /// The default constructor: Intentionally private and undefined

  // handles for creating an opencl context 
  std::vector<cl::Device> devices;        
  cl::Context context;

  cl::CommandQueue queue;
  cl::Program program;

  cl::Kernel rotate_kernel;
        
  // Needed for performance measurements
  cl::Event event;

  // Source and target image data
  cl_uchar4 *target; 
  cl_uchar4 *black_target; 
  cl_uchar4 *source; 

  // The buffer
  cl::Buffer source_buffer; // For the image to be rotated
  cl::Buffer target_buffer; // For rotated images
};

#endif /* LOGOROTATE_HPP_ */
