<?php
// laden der Datenbank-Verbindungsparameter
include 'db_config.php';

// Datenbankverbindung über PDO aufbauen 
$pdo = new PDO(
	$db_config['dsn'], 
	$db_config['user'], 
	$db_config['password'],
	array(PDO::MYSQL_ATTR_INIT_COMMAND => "SET NAMES utf8")
);

// Datenbank-Abfrage erzeugen
$stmt = $pdo->prepare(
	'SELECT city_name, CONVERT(sum(spendings), UNSIGNED) AS sum_per_city '. 
	'FROM cities_and_spendings '.
	'GROUP BY city_name '.
	'ORDER BY sum_per_city DESC LIMIT 36;');

// Datenbank-Abfrage ausführen
$stmt->execute();

// JSON-String erstellen
$json_result = "\{\n\t\"name\" : \"Deutschland\",\n\t\"info\" : \"iX\",\n\t\"children\" : [\n";
            	
while($r = $stmt->fetch(PDO::FETCH_ASSOC)) {
    $json_result = $json_result . "\t\t{\"name\" : \"{$r['city_name']}\", \"size\":{$r['sum_per_city']} },\n";
}
$json_result = substr($json_result, 1, strlen($json_result)-3);
$json_result = $json_result. "\n\t]\n}\n";

// JSON-String ausgeben
print $json_result;
?>
