var canvas = null;
var context = null;

var gameLoop;
var framePerSecond = 60; //Anzahl Bilder pro Sekunde

var mouseX = -1;
var mouseY = -1;

var isDebugDraw = true;
var isGameRunning = false;
var currentAction = null;

var currentMouseJoint = null;

var actionPositionsX = null;
var actionPositionsY = null;
var selectedBody = null;

var world;
var drawingScale = 30.0;

var contactListner = null;

var freddyImage = null;
var fishBody = null;

var pingSound = null;

b2Vec2 = Box2D.Common.Math.b2Vec2;
b2AABB = Box2D.Collision.b2AABB;
b2BodyDef = Box2D.Dynamics.b2BodyDef;
b2Body = Box2D.Dynamics.b2Body;
b2ContactListener = Box2D.Dynamics.b2ContactListener;
b2FixtureDef = Box2D.Dynamics.b2FixtureDef;
b2Fixture = Box2D.Dynamics.b2Fixture;
b2MouseJointDef = Box2D.Dynamics.Joints.b2MouseJointDef;
b2RevoluteJointDef = Box2D.Dynamics.Joints.b2RevoluteJointDef;
b2World = Box2D.Dynamics.b2World;
b2MassData = Box2D.Collision.Shapes.b2MassData;
b2PolygonShape = Box2D.Collision.Shapes.b2PolygonShape;
b2CircleShape = Box2D.Collision.Shapes.b2CircleShape;
b2DebugDraw = Box2D.Dynamics.b2DebugDraw;  //Einfacher Schreibweise fr Box2D

function Run() { //Startet das Spiel
    canvas = document.getElementById('canvas');
    if (canvas && canvas.getContext) {
        //Canvas und GetContext wird von Browser unterstzt

        context = canvas.getContext('2d');
       
        LoadContent();
        Initialize();
        gameLoop = setInterval(DoGameLoop, 1000/framePerSecond);
    }
}

function LoadContent() { //Ldt Bilder, Sound usw.
    freddyImage = new Image();
    freddyImage.src = "freddy.png";

    //pingSound = new Audio('ping.mp3');
}

function Initialize() { //Initialisiert das Spiel

    canvas.addEventListener('mousemove', MousemoveHandler, false);
    canvas.addEventListener('mousedown', MousedownHandler, false);
    canvas.addEventListener('mouseup', MouseupHandler, false);

    canvas.onselectstart = function () { return false; }; //Kein TextSelection

    world = new b2World(
               new b2Vec2(0, 10)    //gravity
            , true                 //allow sleep
         );

    var fixDef = new b2FixtureDef;
    fixDef.density = 1.0;
    fixDef.friction = 0.5;
    fixDef.restitution = 0.2;

    var bodyDef = new b2BodyDef;

    //create ground
    bodyDef.type = b2Body.b2_staticBody;
    bodyDef.position.x = 11;
    bodyDef.position.y = 13;
    fixDef.shape = new b2PolygonShape;
    fixDef.shape.SetAsBox(10, 0.5);
    world.CreateBody(bodyDef).CreateFixture(fixDef);

    //create some objects
    bodyDef.type = b2Body.b2_dynamicBody;
    for (var i = 0; i < 10; ++i) {
        if (Math.random() > 0.5) {
            fixDef.shape = new b2PolygonShape;
            fixDef.shape.SetAsBox(
                     Math.random() + 0.1 //half width
                  , Math.random() + 0.1 //half height
               );
        } else {
            fixDef.shape = new b2CircleShape(
                  Math.random() + 0.1 //radius
               );
        }
        bodyDef.position.x = Math.random() * 10+4;
        bodyDef.position.y = Math.random() * 10;
        world.CreateBody(bodyDef).CreateFixture(fixDef);
    }

    //setup debug draw
    InitializeDebugDraw()

}

function InitializeDebugDraw() {
    var debugDraw = new b2DebugDraw();
    debugDraw.SetSprite(context);
    debugDraw.SetDrawScale(drawingScale);
    debugDraw.SetFillAlpha(0.3);
    debugDraw.SetLineThickness(1.0);
    debugDraw.SetFlags(b2DebugDraw.e_shapeBit | b2DebugDraw.e_jointBit);
    world.SetDebugDraw(debugDraw);
}

function DoGameLoop() { //Spieleschleife
    Update();
    Draw();
}

function Update() { //Anwender-Eingaben verarbeiten; Bewegung berechnen

    if (!isGameRunning) {
        return
    }

    world.Step(1 / framePerSecond, //frame-rate
               10,       //velocity iterations
               10);       //position iterations
}

function Draw() { //Zeichnen
    if (isDebugDraw) {
        world.DrawDebugData();
    } else {
        context.clearRect(0, 0, canvas.width, canvas.height);
        DrawBodies(world);
    }

    if (selectedBody) DrawBody(selectedBody,true);

    if (currentAction != null) {
        context.fillStyle = "red";
        context.strokeStyle = "red";
        switch (currentAction) {
            case "CreateNewBox":  context.fillRect(actionPositionsX[0], actionPositionsY[0], 
                                        mouseX-actionPositionsX[0], mouseY-actionPositionsY[0]);
                break;
            case "CreateNewCircle": context.beginPath();
                                    context.arc(actionPositionsX[0], actionPositionsY[0],
                                                    distance(actionPositionsX[0],actionPositionsY[0],mouseX,mouseY),
                                                    0, Math.PI * 2, true);
                                    context.closePath();
                                    context.fill();
                                    break;
            case "CreateNewPolygon": DrawNewPloygon()
                                     break;
            case "AddPolygonFixture": DrawNewPloygon()
                                      break;
        }
           
    }

    context.fillStyle = "#EEF315"
    context.font = "bold 24px sans-serif";


    world.ClearForces();
}

function DrawNewPloygon() {
    context.beginPath();
    context.moveTo(actionPositionsX[0], actionPositionsY[0]);
    for (var i = 1; i < actionPositionsX.length; i++) {
        context.lineTo(actionPositionsX[i], actionPositionsY[i]);
    }
    context.lineTo(mouseX, mouseY)
    context.stroke();

    if (isNearFirstPolygonVertex()) {
        DrawMarker(actionPositionsX[0], actionPositionsY[0])
    }
}

function EndActionCreateNewBox() {
    CreateNewBox(actionPositionsX[0] / drawingScale, actionPositionsY[0] / drawingScale,
                 (mouseX - actionPositionsX[0]) / drawingScale, (mouseY - actionPositionsY[0]) / drawingScale);
}

function EndActionCreateNewCircle() {
    CreateNewCircle(actionPositionsX[0] / drawingScale, actionPositionsY[0] / drawingScale,
                    distance(actionPositionsX[0], actionPositionsY[0], mouseX, mouseY) / drawingScale);
}

function isNearFirstPolygonVertex() {
    return (actionPositionsX.length > 2 && distance(actionPositionsX[0], actionPositionsY[0],
                                                mouseX, mouseY) < 8);
}

function changePolygonVertexToBox2D() {
    actionPositionsX.pop(); //Letzten, doppelten Punkt enfernen
    actionPositionsY.pop();

    if (!isPolygonClockwise(actionPositionsX, actionPositionsY)) {
        actionPositionsX.reverse();
        actionPositionsY.reverse();
    };

    for (var i = 0; i < actionPositionsX.length; i++) {
        actionPositionsX[i] = actionPositionsX[i] / drawingScale;
        actionPositionsY[i] = actionPositionsY[i] / drawingScale;
    }
}

function EndActionCreateNewPolygon() {
    if (isNearFirstPolygonVertex()) {

        changePolygonVertexToBox2D();

        CreateNewPolygon(actionPositionsX, actionPositionsY);

        currentAction = null;
    }
}

function EndActionAddPolygonFixture() {
    if (isNearFirstPolygonVertex()) {

        changePolygonVertexToBox2D();

        AddPolygonFixture(selectedBody,actionPositionsX, actionPositionsY);

        currentAction = null;
    }
}

function isPolygonClockwise(x, y) {
    var wert = (x[1] - x[0]) * (y[2] - y[1]) - (y[1] - y[0]) * (x[2] - x[1]);
    if (wert > 0) {
        return true;
    } else {
        return false;
    }
}

function CreateFish() {
    var bodyDef = new b2BodyDef;
    bodyDef.type = b2Body.b2_dynamicBody;

    var result = world.CreateBody(bodyDef);

    var position = new b2Vec2();
    position.Set(200 / drawingScale, 100 / drawingScale);
    result.SetPosition(position);

    var xValues = new Array();
    var yValues = new Array();

    xValues[1] = new Array(7.32, 7.14, 7.1, 7.36, 7.56, 8.04, 8.44, 8.8, 9, 8.92, 8.68, 8.5);
    yValues[1] = new Array(4.84, 4.56, 4.34, 3.98, 3.84, 3.72, 3.76, 3.9, 4.12, 4.2, 4.38, 4.44);
    AddPolygonFixture(result, xValues[1], yValues[1]); 

    xValues[2] = new Array(7.320754716981132,  7.113207547169812,  6.886792452830188,  6.7924528301886795,  6.811320754716981,  7.0754716981132075);
    yValues[2] = new Array(3.9622641509433962, 3.9056603773584904, 3.7735849056603774, 3.792452830188679,3.981132075471698, 4.320754716981132);
    AddPolygonFixture(result, xValues[2], yValues[2]);

    xValues[3] = new Array(8.5,  8.948275862068966,  8.724137931034482,  8.5,  7.827586206896552,  7.4655172413793105, 7.327586206896552);
    yValues[3] = new Array(4.4655172413793105,4.810344827586207,5.017241379310345,5.120689655172414,5.155172413793103, 4.9655172413793105,4.827586206896552);
    AddPolygonFixture(result, xValues[3], yValues[3]);

    xValues[4] = new Array(7.2745098039215685, 7.03921568627451, 6.745098039215686, 6.666666666666667, 7.137254901960785);
    yValues[4] = new Array(4.8431372549019605, 5.137254901960785, 5.137254901960785, 5, 4.568627450980392);
    AddPolygonFixture(result, xValues[4], yValues[4]);

    xValues[5] = new Array(7.578947368421052, 7.473684210526316, 7.649122807017544, 8);
    yValues[5] = new Array(3.789473684210526, 3.5789473684210527, 3.56140350877193, 3.6491228070175437);
    AddPolygonFixture(result, xValues[5], yValues[5]);

    xValues[6] = new Array(8.5, 8.209677419354838, 8.209677419354838, 8.274193548387096, 8.435483870967742, 8.548387096774194, 8.758064516129032);
    yValues[6] = new Array(3.725806451612903,3.7096774193548385, 3.4838709677419355, 3.3548387096774195, 3.338709677419355, 3.403225806451613, 3.8548387096774195);
    AddPolygonFixture(result, xValues[6], yValues[6]);

    xValues[7] = new Array(8.576271186440678,  8.59322033898305, 8.694915254237289, 8.830508474576272, 8.830508474576272, 8.76271186440678);
    yValues[7] = new Array(3.4237288135593222, 3.3389830508474576, 3.3389830508474576, 3.542372881355932, 3.8135593220338984, 3.847457627118644);
    AddPolygonFixture(result, xValues[7], yValues[7]);



    return result;
}

function CreateNewBox(x, y, width, height) {

    var bodyDef = new b2BodyDef;
    bodyDef.type = b2Body.b2_dynamicBody;

    var fixDef = new b2FixtureDef;
    fixDef.density = 1.0;
    fixDef.friction = 0.5;
    fixDef.restitution = 0.2;
    fixDef.shape = new b2PolygonShape;
    fixDef.shape.SetAsBox(width/2,height/2);
    
    bodyDef.position.x = x+width/2;   //Position im Zentrum der Box
    bodyDef.position.y = y+height/2;

    world.CreateBody(bodyDef).CreateFixture(fixDef);
}

function AddPolygonFixture(body, x, y) {

    var fixDef = new b2FixtureDef;
    fixDef.density = 1.0;
    fixDef.friction = 0.5;
    fixDef.restitution = 0.2;

    var vecs = [];
    for (var i = 0; i < x.length; i++) {
        var vec = new b2Vec2();
        vec.Set(x[i], y[i]);
        var vecLocal = body.GetLocalPoint(vec);
        vecs[i] = vecLocal;
    }

    fixDef.shape = new b2PolygonShape;
    fixDef.shape.SetAsArray(vecs, vecs.length);

    body.CreateFixture(fixDef);
}

function CreateNewPolygon(x, y) {

    var bodyDef = new b2BodyDef;
    bodyDef.type = b2Body.b2_dynamicBody;

    var fixDef = new b2FixtureDef;
    fixDef.density = 1.0;
    fixDef.friction = 0.5;
    fixDef.restitution = 0.2;

    var vecs = [];
    for (var i = 0; i < x.length; i++) {
        var vec = new b2Vec2();
        vec.Set(x[i], y[i]);
        vecs[i] = vec;
    }

    fixDef.shape = new b2PolygonShape;
    fixDef.shape.SetAsArray(vecs, vecs.length);

//    bodyDef.position.x = 0;   //Position im Zentrum der Box
//    bodyDef.position.y = 0;

    world.CreateBody(bodyDef).CreateFixture(fixDef);
}

function CreateNewCircle(x, y, radius) {

    var bodyDef = new b2BodyDef;
    bodyDef.type = b2Body.b2_dynamicBody;

    var fixDef = new b2FixtureDef;
    fixDef.density = 1.0;
    fixDef.friction = 0.5;
    fixDef.restitution = 0.2;
    fixDef.shape = new b2CircleShape(radius);

    bodyDef.position.x = x;   //Position im Zentrum des Circles
    bodyDef.position.y = y;

    world.CreateBody(bodyDef).CreateFixture(fixDef);
}

var resultBody = null;

function GetBodyAtPositionCallback(fixture) {
    resultBody = fixture.GetBody();
    return false;  //nicht mehr weiter suchen
}

function GetBodyAtPosition(x,y) {
    var vec = new b2Vec2();
    vec.Set(x, y);

    resultBody = null;

    world.QueryPoint(GetBodyAtPositionCallback,vec);

    return resultBody;
}

function DrawMarker(x, y) {
    context.fillStyle = "yellow";
    context.globalalpha = 0.5;
    context.beginPath();
    context.arc(x, y, 8, 0, Math.PI * 2, true);
    context.closePath();
    context.fill();
    context.globalalpha = 1.0;
}

function DrawBodies(world) {
    for (var body = world.GetBodyList(); body != null; body = body.GetNext()) {

        if (body == fishBody) {
            if (freddyImage.complete == true) {
                context.save();
                context.translate(body.GetPosition().x * drawingScale, body.GetPosition().y * drawingScale);
                context.rotate(body.GetAngle());
                context.drawImage(freddyImage, 0, 0,
                            freddyImage.width / 16 * drawingScale, freddyImage.height / 16 * drawingScale);
                context.restore();
                
            }
        } else {
            DrawBody(body, body == selectedBody);
        }
    }
}

function DrawBody(body,marked) {
  context.save();
  context.translate(body.GetPosition().x * drawingScale, body.GetPosition().y * drawingScale); //Get the world body origin position.
  context.rotate(body.GetAngle()); //Aktuelle Rotation in Radians
  context.fillStyle = "grey";
  if (marked) {
      context.strokeStyle = "black";
  } else {
      context.strokeStyle = "grey";
  }

  for (var fixture = body.GetFixtureList() ; fixture != null ; fixture = fixture.GetNext()) {
      var shape = fixture.GetShape();

      if (shape.GetType() == 0) {  //Kreis?
          var radius = shape.GetRadius();
          context.beginPath();
          context.arc(0, 0,radius * drawingScale,0, Math.PI * 2, true);
          context.closePath();
          context.fill();
      } else {
          var vertices = shape.GetVertices(); //Punkte in lokalen Koordinaten
          context.beginPath();
          context.moveTo( vertices[0].x * drawingScale, vertices[0].y * drawingScale);
          for (var j = 1; j < vertices.length; j++) {
              context.lineTo(vertices[j].x * drawingScale, vertices[j].y * drawingScale);
          }
          context.lineTo((this.x + vertices[0].x) * drawingScale, (this.y + vertices[0].y) * drawingScale);
          context.closePath();
      }

      context.fill();
      context.stroke();
  }
  
  context.restore();
}

function GetFixtureCoordinates(body) {
    var result = "(";
    for (var fixture = body.GetFixtureList(); fixture != null; fixture = fixture.GetNext()) {
        result = result + "(";
        var shape = fixture.GetShape();
        var shapeString = "";
        var vertices = shape.GetVertices();

        for (var j = 0; j < vertices.length; j++) {
            if (shapeString.length > 0) shapeString = shapeString + ", ";
            shapeString = shapeString + String(vertices[j].x) + ", " + String(vertices[j].y);
        }
        result = result + shapeString + ")";
    }
    result = result + ")"
    return result;
}

function AddContactListener() {
    if (contactListner == null) {
        contactListner = new b2ContactListener;

        contactListner.BeginContact = function (contact) {
            var bodyA = contact.GetFixtureA().GetBody();
            var bodyB = contact.GetFixtureB().GetBody();

            if (selectedBody != null) {
                if (selectedBody == bodyA || selectedBody == bodyB) {
                    //pingSound.play();
                }
            }
        }

        contactListner.EndContact = function (contact) {

        }

        contactListner.PostSolve = function (contact, impulse) {
        
        }
        
        contactListner.PreSolve = function (contact, oldManifold) {
        }

        world.SetContactListener(contactListner);
    }
}

function CreateMouseJoint() {
    var body = GetBodyAtPosition(mouseX / drawingScale, mouseY / drawingScale);

    if (body) {
        var mouseJointDef = new b2MouseJointDef;
        mouseJointDef.bodyA = world.GetGroundBody();  //Referenzpunkt 
        mouseJointDef.bodyB = body;
        mouseJointDef.target.Set(mouseX/drawingScale,mouseY/drawingScale);
        mouseJointDef.collideConnected = true;
        mouseJointDef.maxForce = 300.0 * body.GetMass();
        currentMouseJoint= world.CreateJoint(mouseJointDef);
    }
}

function CreateRevoluteJoint(body){
    var revoluteJointDef = new b2RevoluteJointDef();
    revoluteJointDef.Initialize(body,
                                world.GetGroundBody(),
                                body.GetWorldCenter());
    revoluteJointDef.maxMotorTorque = 1.0;
    revoluteJointDef.enableMotor = true; 
    world.CreateJoint(revoluteJointDef);
}

function distance(x1, y1, x2, y2) {
    return Math.sqrt(Math.pow(x2 - x1, 2) + Math.pow(y2 - y1, 2));
}

function MousemoveHandler(ev) {
    // Get the mouse position relative to the canvas element.
    if (ev.layerX || ev.layerX == 0) { // Firefox, IE
        mouseX = ev.layerX;
        mouseY = ev.layerY;
    } else if (ev.offsetX || ev.offsetX == 0) { // Opera
        mouseX = ev.offsetX;
        mouseY = ev.offsetY;
    }

    if (currentAction == "UseMouseJoint") {
        var mousePosition = new b2Vec2(mouseX / drawingScale, mouseY / drawingScale);
        currentMouseJoint.SetTarget(mousePosition);
    }
}

function MouseupHandler() {

    switch (currentAction) {
        case "CreateNewBox": EndActionCreateNewBox();
            currentAction = null;
            break;

        case "CreateNewCircle": EndActionCreateNewCircle();
            currentAction = null;
            break;
        case "CreateNewPolygon": EndActionCreateNewPolygon();
            break;
        case "AddPolygonFixture": EndActionAddPolygonFixture();
            break;
        case "UseMouseJoint": world.DestroyJoint(currentMouseJoint);
            currentMouseJoint=null;
            currentAction=null;
            break;
    }
}

function MousedownHandler() {
    if (!currentAction) {
        currentAction = document.getElementById("ActionDropDownList").value;
        actionPositionsX = new Array(0);
        actionPositionsY = new Array(0);
    }

    switch (currentAction) {
        case "RemoveBody":  var body = GetBodyAtPosition(mouseX / drawingScale, mouseY / drawingScale);
                            if (body) {
                                world.DestroyBody(body);
                            }
                            currentAction = null;
                            break;
        case "AddFish": if (fishBody==null) {
                                fishBody = CreateFish();
                            }
                            currentAction = null;
                            break;
        case "ApplyImpulsetoBody":  var body = GetBodyAtPosition(mouseX / drawingScale, mouseY / drawingScale);
                                    if (body) {
                                        body.ApplyImpulse(new b2Vec2(0 , - 7), body.GetWorldCenter());
                                    }
                                    currentAction = null;
                                    break;
         case "CreateRevolutJoint": var body = GetBodyAtPosition(mouseX / drawingScale, mouseY / drawingScale);
                                    if (body) {
                                        CreateRevoluteJoint(body);
                                    }
                                    currentAction = null;
                                    break;
        case "UseMouseJoint": CreateMouseJoint();
                              break;
                                case "SelectBody": var body = GetBodyAtPosition(mouseX / drawingScale, mouseY / drawingScale);
                                    if (body) {
                                        if (selectedBody == body) {
                                            selectedBody = null;
                                        } else {
                                            selectedBody = body;
                                            AddContactListener();
                                            //prompt("String:", GetFixtureCoordinates(selectedBody));
                                        }
                                    }
                                    currentAction = null;
        default: actionPositionsX[actionPositionsX.length] = mouseX;
                 actionPositionsY[actionPositionsY.length] = mouseY;
    }
    
}

function OnChangePlayCheckbox() {
    var isChecked = document.getElementById("PlayCheckbox").value;
    if (isChecked == "on") {
        isGameRunning = true;
    }
    else {
        isGameRunning = false;
    }
}

function OnChangeDrawCheckbox() {
    var isChecked = document.getElementById("DrawCheckbox").value;
    if (isChecked == "on") {
        isDebugDraw = true;
    }
    else {
        isDebugDraw = false;
    }
}

function OnInputZoomTextbox() {
    var value = document.getElementById("ZoomTextbox").value;
    drawingScale = parseFloat(value);

    InitializeDebugDraw();
}