var canvas = null;
var context = null;

var gameLoop;
var framePerSecond = 60; //Anzahl Bilder pro Sekunde

var world;
var drawingScale = 30.0;

function Run() { //Startet das Spiel
	canvas = document.getElementById('canvas');
	if (canvas && canvas.getContext) {
		//Canvas und GetContext wird von Browser unterstzt

		context = canvas.getContext('2d');
	   
		Initialize();
		gameLoop = setInterval(DoGameLoop, 1000/framePerSecond);
	}
}

function Initialize() { //Initialisiert das Spiel

var b2Vec2 = Box2D.Common.Math.b2Vec2       
  , b2BodyDef = Box2D.Dynamics.b2BodyDef
  , b2Body = Box2D.Dynamics.b2Body
  , b2FixtureDef = Box2D.Dynamics.b2FixtureDef
  , b2Fixture = Box2D.Dynamics.b2Fixture
  , b2World = Box2D.Dynamics.b2World
  , b2MassData = Box2D.Collision.Shapes.b2MassData
  , b2PolygonShape = Box2D.Collision.Shapes.b2PolygonShape
  , b2CircleShape = Box2D.Collision.Shapes.b2CircleShape
  , b2DebugDraw = Box2D.Dynamics.b2DebugDraw;  //Einfacher Schreibweise fr Box2D

	world = new b2World(
			   new b2Vec2(0, 10)    //gravity
			, true                 //allow sleep
		 );

	var fixDef = new b2FixtureDef;
	fixDef.density = 1.0;
	fixDef.friction = 0.5;
	fixDef.restitution = 0.2;

	var bodyDef = new b2BodyDef;

	//Grundplatte erzeugen
	bodyDef.type = b2Body.b2_staticBody;
	bodyDef.position.x = 11;
	bodyDef.position.y = 13;
	fixDef.shape = new b2PolygonShape;
	fixDef.shape.SetAsBox(10, 0.5);
	world.CreateBody(bodyDef).CreateFixture(fixDef);

	//Einige Objekte erzeugen
	bodyDef.type = b2Body.b2_dynamicBody;
	for (var i = 0; i < 10; ++i) {
		if (Math.random() > 0.5) {
			fixDef.shape = new b2PolygonShape;
			fixDef.shape.SetAsBox(
					 Math.random() + 0.1 //half width
				  , Math.random() + 0.1 //half height
			   );
		} else {
			fixDef.shape = new b2CircleShape(
				  Math.random() + 0.1 //radius
			   );
		}
		bodyDef.position.x = Math.random() * 10+4;
		bodyDef.position.y = Math.random() * 10;
		world.CreateBody(bodyDef).CreateFixture(fixDef);
	}

	//setup debug draw
	var debugDraw = new b2DebugDraw();
	debugDraw.SetSprite(context);
	debugDraw.SetDrawScale(30.0);
	debugDraw.SetFillAlpha(0.3);
	debugDraw.SetLineThickness(1.0);
	debugDraw.SetFlags(b2DebugDraw.e_shapeBit | b2DebugDraw.e_jointBit);
	world.SetDebugDraw(debugDraw);
}

function DoGameLoop() { //Spieleschleife
	Update();
	Draw();
}

function Update() { //Anwender-Eingaben verarbeiten; Bewegung berechnen

	world.Step(1 / framePerSecond, //frame-rate
			   10,       //velocity iterations
			   10);       //position iterations
}

function Draw() { //Zeichnen
	world.DrawDebugData();
	world.ClearForces();
}

