﻿using System;
using System.Net;

namespace iXTankeniOS
{
    public class AddNewViewModel:ViewModelBase
    {
        private TankVorgang _newTankVorgang= null;

        public AddNewViewModel()
        {

            NewTankVorgang = new TankVorgang();
        }


        public void CommitDataAction(object p)
        {
            ITankvorgangModelService tankvorgangModelService = this.GetService<ITankvorgangModelService>();
            if (tankvorgangModelService == null)
            {
                return;
            }

            tankvorgangModelService.AddNewTankVorgang(NewTankVorgang);

            INavigationService tankVorgangNavigationService = this.GetService<INavigationService>();
            if (tankVorgangNavigationService == null)
            {
                return;
            }

            tankVorgangNavigationService.NavigateBack();
        }

        public void RollbackDataAction(object p)
        {
           
            INavigationService tankVorgangNavigationService = this.GetService<INavigationService>();
            if (tankVorgangNavigationService == null)
            {
                return;
            }

            tankVorgangNavigationService.NavigateBack();
        }

        public DateTime Datum
        {
            get
            {
                return NewTankVorgang.Datum;
            }
            set
            {
                if (NewTankVorgang.Datum != value)
                {
                    NewTankVorgang.Datum = value;
                }
            }
        }

        public Double Kilometerstand 
        {
            get
            {
                return NewTankVorgang.Kilometerstand;
            }
            set
            {
                if (NewTankVorgang.Kilometerstand != value)
                {
                    NewTankVorgang.Kilometerstand = value;
                }
            }
        }

        public Double Menge 
        {
            get
            {
                return NewTankVorgang.Menge;
            }
            set
            {
                if (NewTankVorgang.Menge != value)
                {
                    NewTankVorgang.Menge = value;
                }
            }
        }

        public Double Betrag 
        {
            get
            {
                return NewTankVorgang.Betrag;
            }
            set
            {
                if (NewTankVorgang.Betrag != value)
                {
                    NewTankVorgang.Betrag = value;
                }
            }
        }

        public String Anmerkung 
        {
            get
            {
                return NewTankVorgang.Anmerkung;
            }
            set
            {
                if (NewTankVorgang.Anmerkung != value)
                {
                    NewTankVorgang.Anmerkung = value;
                }
            }
        }

        public TankVorgang NewTankVorgang
        { 
            get 
            {
                return this._newTankVorgang;
            }
            set 
            { 
                if (this._newTankVorgang != value) 
                {
                    this._newTankVorgang = value;
                    this.NewTankVorgang.Datum = value.Datum; 
                } 
            }
        }
    }
}
