package com.thomaskuenneth.artikel.ix;

import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;

import java.awt.GraphicsDevice;
import java.awt.GraphicsDevice.WindowTranslucency;
import java.awt.GraphicsEnvironment;

@SuppressWarnings("serial")
public class WindowOpacityDemo2 extends JFrame {

    private final JSlider slider;
    private final Color bgnd;

    public static void main(String[] args) {
        // Initialisierung der GUI immer auf dem EDT
        SwingUtilities.invokeLater(new Runnable() {

            @Override
            public void run() {
                // Steht Transparenz auf Pixelebene zur Verfügung?
                GraphicsEnvironment ge =
                        GraphicsEnvironment.getLocalGraphicsEnvironment();
                GraphicsDevice gd = ge.getDefaultScreenDevice();
                if (gd.isWindowTranslucencySupported(WindowTranslucency.PERPIXEL_TRANSLUCENT)) {
                    WindowOpacityDemo2 frame = new WindowOpacityDemo2();
                    frame.setVisible(true);
                } else {
                    System.err.println("WindowTranslucency.PERPIXEL_TRANSLUCENT nicht unterstützt");
                    System.exit(1);
                }
            }
        });
    }

    public WindowOpacityDemo2() {
        super("WindowOpacityDemo2");
        setUndecorated(true);
        setResizable(false);
        bgnd = getBackground();
        // Benutzeroberfläche zusammensetzen
        JPanel cp = new JPanel(new FlowLayout(FlowLayout.LEADING, 10, 10));
        // Slider für Werte zwischen 0 und 255
        slider = new JSlider(JSlider.VERTICAL, 0, 255, 200);
        cp.add(slider);
        // Schaltfläche zum Übernehmen des aktuellen Slider-Werts
        JButton button1 = new JButton("Übernehmen");
        button1.addActionListener(new ActionListener() {

            @Override
            public void actionPerformed(ActionEvent e) {
                updateOpacity();
            }
        });
        cp.add(button1);
        // Schaltfläche zum Beenden der Demo
        JButton button2 = new JButton("Beenden");
        button2.addActionListener(new ActionListener() {

            @Override
            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        cp.add(button2);
        setContentPane(cp);
        pack();
        setLocation(100, 100);
        // erstmals voreingestellten Wert setzen
        updateOpacity();
    }

    private void updateOpacity() {
        Color c = new Color(bgnd.getRed(), bgnd.getGreen(), bgnd.getBlue(),
                slider.getValue());
        setBackground(c);
    }
}