package com.thomaskuenneth.artikel.ix;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.Painter;
import javax.swing.SwingUtilities;

public class PainterDemo extends JFrame {

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable() {

            @Override
            public void run() {
                new PainterDemo().setVisible(true);
            }
        });
    }

    public PainterDemo() {
        super("PainterDemo");
        setDefaultCloseOperation(EXIT_ON_CLOSE);
        final Painter<JPanel> painter = new Painter<JPanel>() {

            @Override
            public void paint(Graphics2D g, JPanel p, int width, int height) {
                g.setColor(Color.red);
                g.fillRect(0, 0, width, height);
                g.setColor(Color.white);
                g.drawLine(0, 0, width - 1, height - 1);
                g.drawLine(0, height - 1, width - 1, 0);
            }
        };

        JPanel p = new JPanel() {

            @Override
            public void paint(Graphics g) {
                painter.paint((Graphics2D) g, this, getWidth(), getHeight());
            }
        };
        setContentPane(p);
        pack();
    }
}
