package ix;

import org.junit.experimental.theories.DataPoint;
import org.junit.experimental.theories.DataPoints;
import org.junit.experimental.theories.Theories;
import org.junit.experimental.theories.Theory;
import org.junit.runner.RunWith;

import java.math.BigInteger;

import static org.hamcrest.CoreMatchers.*;
import static org.junit.Assert.assertThat;
import static org.junit.Assume.assumeThat;

@RunWith(Theories.class)
public class TheoriesTest {

    @DataPoint public static BigInteger ZERO = new BigInteger("0");

    @DataPoints
    public static BigInteger[] moreNumbers() {
        return new BigInteger[] {
            new BigInteger("1"),
            new BigInteger("-2"),
            new BigInteger("12345678901234567890")
        };
    }

    @Theory
    public void testCommutativeLawForMultiply(BigInteger i1, BigInteger i2) {
        assertThat(i1.multiply(i2), is(equalTo(i2.multiply(i1))));
    }

    @Theory
    public void testThatMultiplyIsInverseOfDivide(BigInteger i1, BigInteger i2) {
        assumeThat(i2, is(not(ZERO)));
        assertThat(i1.multiply(i2).divide(i2), is(equalTo(i1)));
    }
}
