package ix;

import org.junit.rules.MethodRule;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;

import javax.imageio.ImageIO;
import java.awt.*;
import java.awt.image.BufferedImage;
import java.io.File;

public class TakeScreenshotOnFailure implements MethodRule {

    @Override
    public Statement apply(final Statement base, final FrameworkMethod method, final Object target) {
        return new Statement() {
            @Override
            public void evaluate() throws Throwable {
                MultiException me = new MultiException();
                try {
                    base.evaluate();
                } catch (Throwable t1) {
                    me.add(t1);
                    try {
                        Toolkit toolkit = Toolkit.getDefaultToolkit();
                        Dimension screenSize = toolkit.getScreenSize();
                        File screenshotFile = new File(target.getClass().getSimpleName() + "." + method.getName() + ".png");
                        BufferedImage screenshot = (new Robot()).createScreenCapture(new Rectangle(0, 0, screenSize.width, screenSize.height));
                        ImageIO.write(screenshot, "png", screenshotFile);
                        System.out.println("Screenshot saved to " + screenshotFile + " ...");
                    } catch (Throwable t2) { me.add(t2); }
                }
                me.throwExceptionIfNotEmpty();
            }
        };
    }
}
