package ix;

import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

import java.io.File;
import java.io.IOException;

import static org.hamcrest.CoreMatchers.is;
import static org.junit.Assert.assertThat;

public class RuleTest {

    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Test
    public void testRename() throws IOException{
        File foo = new File(temporaryFolder.getRoot(), "foo");
        assertThat(foo.createNewFile(), is(true));
        File bar = new File(temporaryFolder.getRoot(), "bar");
        assertThat(foo.renameTo(bar), is(true));
        assertThat(foo.exists(), is(false));
        assertThat(bar.exists(), is(true));
    }
}
