package ix;

import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerScheduler;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class ParallelRunner extends BlockJUnit4ClassRunner{

    private static final ExecutorService THREAD_POOL = Executors.newCachedThreadPool();

    public ParallelRunner(Class<?> klass) throws InitializationError {
        super(klass);
        setScheduler(
            new RunnerScheduler() {
                private final List<Future<?>> futures = new ArrayList<Future<?>>();

                @Override
                public void schedule(final Runnable childStatement) {
                    futures.add(THREAD_POOL.submit(new Callable<Object>() {
                        public Object call() throws Exception {
                            childStatement.run();
                            return null;
                        }
                    }));
                }

                @Override
                public void finished() {
                    // Make sure all tests have finished by calling get on each Future ...
                    MultiException me = new MultiException();
                    for (Future<?> future : futures) {
                        try {
                            future.get();
                        } catch (Exception e) { me.add(e); }
                    }
                    me.throwRuntimeExceptionIfNotEmpty();
                }
            }
        );
    }
}
