package ix;

import org.hamcrest.Description;
import org.junit.internal.matchers.TypeSafeMatcher;

import java.util.regex.Pattern;

public class MatchesPattern extends TypeSafeMatcher<String> {

    public static MatchesPattern matchesPattern(String regex) {
        return new MatchesPattern(regex);
    }

    private final Pattern pattern;

    public MatchesPattern(String regex) {
        pattern = Pattern.compile(regex);
    }

    @Override
    public boolean matchesSafely(String string) {
        return pattern.matcher(string).matches();
    }

    public void describeTo(Description description) {
        description.appendText("matches regex /" + pattern.pattern() + "/");
    }
}
