package de.heise.ix.jaxws.extended;

import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class PersonManager {
	private final static PersonManager instance = new PersonManager();
	
	private final AtomicLong lastPersonID = new AtomicLong(1);
	private final ConcurrentHashMap<Long, Person> persons = new ConcurrentHashMap<Long, Person>();
	
	private PersonManager() {}	
	
	public static PersonManager getInstance() {
		return instance;
	}
	
	public Person savePerson(Person person) throws Exception {
		if (person == null) {
			throw new Exception("Person is null!");
		}
		else {
			long personID = lastPersonID.getAndIncrement();
			person.setPersonID(personID);
			persons.put(personID, person);
		}
		
		return person;
	}

	public void updatePerson(Person person) throws Exception {
		if (person == null) {
			throw new Exception("Person is null!");
		}
		else if (persons.replace(person.getPersonID(), person) == null) {
			throw new Exception("Person not found!");
		}
	}

	public void deletePerson(Person person) throws Exception {
		if (person == null) {
			throw new Exception("Person is null!");
		}
		else if (persons.remove(person.getPersonID()) == null) {
			throw new Exception("Person not found!");
		}
	}
	
	public Person getPerson(long personID) throws Exception {
		Person person = persons.get(personID);
		
		if (person == null) {
			throw new Exception("Person not found!");
		}
		else {
			return person;
		}
	}
	
	public Collection<Person> getAllPersons() {
		return persons.values();
	}
}