package de.heise.ix.jaxws.extended;

import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlList;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.namespace.QName;

@XmlRootElement
@XmlAccessorType(XmlAccessType.FIELD)
public class Person {
	public static final long UNDEFINED = -1;
	
	@XmlAttribute(name="personid")
	private long personID;
	
	@XmlAttribute(name="firstname")
	private String firstName;
	
	@XmlAttribute(name="lastname")
	private String lastName;
	
	@XmlAttribute(name="dateofbirth")
	private Date dateOfBirth;
	
	@XmlList
	@XmlElement(name="mailaddresses")
	private List<String> mailAddresses;
	
	@XmlElement
	private Address address;
	
	@XmlTransient
	private int status;
	
	public Person() {}

	public Person(String firstName, String lastName, Date dateOfBirth, List<String> mailAddresses, Address address) {
		this.personID = UNDEFINED;
		this.firstName = firstName;
		this.lastName = lastName;
		this.dateOfBirth = dateOfBirth;
		this.mailAddresses = mailAddresses;
		this.address = address;
	}

	public long getPersonID() {
		return personID;
	}
	public void setPersonID(long personID) {
		this.personID = personID;
	}
	
	public String getFirstName() {
		return firstName;
	}
	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}
	
	public String getLastName() {
		return lastName;
	}
	public void setLastName(String lastName) {
		this.lastName = lastName;
	}
	
	public Date getDateOfBirth() {
		return dateOfBirth;
	}
	public void setDateOfBirth(Date dateOfBirth) {
		this.dateOfBirth = dateOfBirth;
	}
	
	public List<String> getMailAddresses() {
		return mailAddresses;
	}
	public void setMailAddresses(List<String> mailAddresses) {
		this.mailAddresses = mailAddresses;
	}
	
	public Address getAddress() {
		return address;
	}
	public void setAddress(Address address) {
		this.address = address;
	}
	
	public int getStatus() {
		return status;
	}
	public void setStatus(int status) {
		this.status = status;
	}
	
	@Override
	public String toString() {
		return "{personID=" + personID + ", firstName=" + firstName + ", lastName=" + lastName + ", dateOfBirth=" + dateOfBirth + ", mailAddresses=" + mailAddresses + ", address=" + address + "}";
	}
	
	public static Person getInstanceWithExampleData() {
		ArrayList<String> mailAddresses = new ArrayList<String>();
		mailAddresses.add("franz.meier@company.com");
		mailAddresses.add("f.meier@organization.org");
		
		Address address = Address.getInstanceWithExampleData();
		
		return new Person("Franz", "Meier", new GregorianCalendar(1975, 0, 1).getTime(), mailAddresses, address);
	}
	
	public static void main(String[] args) throws Exception {
		Person person = getInstanceWithExampleData();
		
		JAXBElement<Person> jaxbElement = new JAXBElement<Person>(new QName("person"), Person.class, person);

		Marshaller marshaller = JAXBContext.newInstance(Person.class).createMarshaller();
		marshaller.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT, Boolean.TRUE);
		
		marshaller.marshal(jaxbElement, System.out);
	}
}