package de.heise.ix.jaxws.extended;

import java.util.Set;

import javax.xml.namespace.QName;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;

public class LoggingSOAPHandler implements SOAPHandler<SOAPMessageContext> {
	@Override
	public void close(MessageContext context) {}

	@Override
	public boolean handleFault(SOAPMessageContext context) {
		return true;
	}

	@Override
	public boolean handleMessage(SOAPMessageContext context) {
		boolean incoming = !(Boolean) context.get(MessageContext.MESSAGE_OUTBOUND_PROPERTY);
		
		System.out.println("LoggingSOAPHandler handles " + (incoming ? "incoming" : "outgoing") + " message ...");
		
		try {
			SOAPMessage message = context.getMessage();
			message.writeTo(System.out);
			
			System.out.println();
		}
		catch (Exception e) {
			e.printStackTrace();
		}
		
		return true;
	}

	@Override
	public Set<QName> getHeaders() {
		return null;
	}
}