package de.heise.ix.jaxws.extended;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;

@XmlType
public class Address {
	private String street;
	private String postalCode;
	private String city;
	private String country;
	
	public Address() {}
	
	public Address(String street, String postalCode, String city, String country) {
		this.street = street;
		this.postalCode = postalCode;
		this.city = city;
		this.country = country;
	}

	@XmlAttribute
	public String getStreet() {
		return street;
	}
	public void setStreet(String street) {
		this.street = street;
	}
	
	@XmlAttribute(name="postalcode")
	public String getPostalCode() {
		return postalCode;
	}
	public void setPostalCode(String postalCode) {
		this.postalCode = postalCode;
	}
	
	@XmlAttribute
	public String getCity() {
		return city;
	}
	public void setCity(String city) {
		this.city = city;
	}
	
	@XmlAttribute
	public String getCountry() {
		return country;
	}
	public void setCountry(String country) {
		this.country = country;
	}

	@Override
	public String toString() {
		return "{street=" + street + ", postalCode=" + postalCode + ", city=" + city + ", country=" + country + "}";
	}
	
	public static Address getInstanceWithExampleData() {
		return new Address("Berliner Str. 123", "14199", "Berlin", "DE");
	}
}