package de.heise.ix.jaxws.extended;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.ws.LogicalMessage;
import javax.xml.ws.handler.LogicalHandler;
import javax.xml.ws.handler.LogicalMessageContext;
import javax.xml.ws.handler.MessageContext;

import de.heise.ix.jaxws.extended.generated.ObjectFactory;
import de.heise.ix.jaxws.extended.generated.Register;

public class AdaptingLogicalHandler implements LogicalHandler<LogicalMessageContext> {
	@Override
	public void close(MessageContext context) {}

	@Override
	public boolean handleFault(LogicalMessageContext context) {
		return true;
	}

	@Override
	public boolean handleMessage(LogicalMessageContext context) {
		boolean incoming = !(Boolean) context.get(MessageContext.MESSAGE_OUTBOUND_PROPERTY);
		
		System.out.println("AdaptingLogicalHandler handles " + (incoming ? "incoming" : "outgoing") + " message ...");
		
		try {
			JAXBContext jaxbContext = JAXBContext.newInstance(ObjectFactory.class);

			LogicalMessage message = context.getMessage();
			Object payload = message.getPayload(jaxbContext);
			
			JAXBElement<?> jaxbElement = null;
		    if (payload instanceof JAXBElement<?>) {
		    	jaxbElement = (JAXBElement<?>) payload;
		    }
			
			if (jaxbElement.getValue() instanceof Register) {
				Register register = (Register) jaxbElement.getValue();
				
				if (register.getPerson().getAddress().getCountry().equals("DE")) {
					register.getPerson().getAddress().setCountry("Deutschland");
					
					message.setPayload(payload, jaxbContext);
					
					System.out.println("AdaptingLogicalHandler adapted message!");					
				}
			}				
		}
		catch (Exception e) {
			e.printStackTrace();
		}
		
		return true;
	}
}