package de.heise.ix.jaxrs.simple;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;

public class EchoResourceClient {
	public static void main(String[] args) throws Exception {
		URL url = new URL("http://localhost:8080/jaxrs/echo?text=Hello+World!");
		
		HttpURLConnection connection = (HttpURLConnection) url.openConnection();
		connection.setRequestMethod("GET");
		connection.connect();
		
		if (connection.getResponseCode() != HttpURLConnection.HTTP_OK) {
			System.err.println(connection.getResponseCode() + " / " + connection.getResponseMessage());
		}
		else {
			BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));

			String line;
			while ((line = in.readLine()) != null) {
				System.out.println(line);
			}
		}
		
		connection.disconnect();
	}
}