package de.heise.ix.jaxrs.extended;

import java.net.URI;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;

public class PersonResourceClient {
	public static void main(String[] args) throws Exception {
		Person person = Person.getInstanceWithExampleData();
		
		Client client = Client.create();

		// Create person ...
		WebResource webResource = client.resource("http://localhost:8080/jaxrs/person");
		ClientResponse response = webResource.post(ClientResponse.class, person);
		URI personURI = response.getLocation();
		
		System.out.println("Person created! => " + personURI);
		
		// Read person ...
		webResource = client.resource(personURI);
		person = webResource.get(Person.class);
		
		System.out.println("Person read! => " + person);

		// Update person ...
		person.setLastName("Meyer");
		webResource.put(person);

		System.out.println("Person updated!");
	
		// Delete person ...
		webResource.delete();
		
		System.out.println("Person deleted!");
		
		// Get all persons ...
		webResource = client.resource("http://localhost:8080/jaxrs/person");
		for (int i = 0; i < 10; i++) {			
			webResource.post(Person.getInstanceWithExampleData());
		}
		
		webResource = client.resource("http://localhost:8080/jaxrs/person/all?maxnumber=3");
		String result = webResource.get(String.class);
		
		System.out.println("All persons got! => " + result);
	}
}