package de.heise.ix.jaxrs.extended;

import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path("/person")
@Consumes(MediaType.APPLICATION_XML)
@Produces(MediaType.APPLICATION_XML)
public interface PersonResource {
	@POST
	public Response createPerson(@Context UriInfo uriInfo, Person person);
	
	@GET
	@Path("/{personid}")
	public Person readPerson(@PathParam("personid") long personID);
	
	@PUT
	@Path("/{personid}")
	public void updatePerson(@PathParam("personid") long personID, Person person);
	
	@DELETE
	@Path("/{personid}")
	public void deletePerson(@PathParam("personid") long personID);
	
	@GET
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/all")
	public String getAllPersons(@QueryParam("maxnumber") @DefaultValue("100") int maxNumber);	
}