﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.ServiceBus;
using System.Runtime.Serialization;
using System.IO;
using System.ServiceModel.Channels;
using System.Diagnostics;

namespace AzureBlog_Logik
{
    public class PostingMessageBufferManager
    {
        MessageBufferClient client;

        public PostingMessageBufferManager()
        {
            MessageBufferPolicy policy;
            TransportClientEndpointBehavior credential;
            Uri bufferUri;

            string bufferName = "PostingBuffer";
            string serviceNamespace = "ix-sample";
            string issuerName = "owner";
            string issuerSecret = "uhI4dQE++QFija47WxjfuUe57i2kay/04V/zEGtpO2U=";


            // Policy erzeugen
            policy = new MessageBufferPolicy();
            policy.Authorization = AuthorizationPolicy.Required;
            policy.Discoverability = DiscoverabilityPolicy.Public;
            policy.ExpiresAfter = TimeSpan.FromMinutes(10);
            policy.MaxMessageCount = 10;
            policy.OverflowPolicy = OverflowPolicy.RejectIncomingMessage;
            policy.TransportProtection = TransportProtectionPolicy.AllPaths;
            
            // Behavior erzeugen
            credential = new TransportClientEndpointBehavior();
            credential.CredentialType = TransportClientCredentialType.SharedSecret;
            credential.Credentials.SharedSecret.IssuerName = issuerName;
            credential.Credentials.SharedSecret.IssuerSecret = issuerSecret;

            // MessageBufferClient erzeugen
            bufferUri = new Uri("https://" + serviceNamespace + ".servicebus.windows.net/services/" + bufferName);
            client = MessageBufferClient.CreateMessageBuffer(credential, bufferUri, policy);
            

        }


        public void Send(AzureBlog_Modell.Beitrag beitrag)
        {
            Message msg;
            string content;

            content = beitrag.Titel + "\n" 
                        + beitrag.Autor.EMail + "\n" 
                        + beitrag.Datum.ToString() + "\n" 
                        + beitrag.Text;

            msg = Message.CreateMessage(MessageVersion.Soap12WSAddressing10, "urn:Message", content);

            try
            {
                client.Send(msg);
            }
            catch (TimeoutException e)
            {
                Trace.WriteLine("MessageBuffer ist voll!");
                Trace.WriteLine(e.ToString());
            }
            
        }

        public void Receive(Action<string> action)
        {
            Message msg;
            TimeSpan timeout;
            TimeSpan lockDuration;
            string body;

            timeout = TimeSpan.FromSeconds(10);
            lockDuration = TimeSpan.FromMinutes(2);

                try
                {
                    msg = client.PeekLock(timeout, lockDuration);
                    body = msg.GetBody<string>();
                }
                catch 
                {
                    body = null;
                    msg = null;
                }

                action(body);

                if (body != null)
                {
                    client.DeleteLockedMessage(msg);
                }
            

            
        }
    }
}
