﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Net;
using System.Threading;
using Microsoft.WindowsAzure;
using Microsoft.WindowsAzure.Diagnostics;
using Microsoft.WindowsAzure.ServiceRuntime;
using Microsoft.WindowsAzure.StorageClient;
using AzureBlog_Logik;

namespace AzureBlog_Worker
{
    public class WorkerRole : RoleEntryPoint
    {
        public Action<string, Func<string, bool>> GetConfigurationSettingPublisher()
        {
            return (configName, configSetter) =>
                configSetter(RoleEnvironment.GetConfigurationSettingValue(configName));
        }

        public override void Run()
        {
            BeitragQueueManager bqm;

            Trace.WriteLine("AzureBlog_Worker entry point called", "Information");
            bqm = new BeitragQueueManager();
            
            while (true)
            {
                bqm.Receive((content) => { 
                    // EMail-Versandt simulieren ...
                    Trace.WriteLine(content, "Information"); 
                });
                Thread.Sleep(10000);
            }
        }

        public override bool OnStart()
        {
            // Set the maximum number of concurrent connections 
            ServicePointManager.DefaultConnectionLimit = 12;

            // For information on handling configuration changes
            // see the MSDN topic at http://go.microsoft.com/fwlink/?LinkId=166357.
            
            CloudStorageAccount.SetConfigurationSettingPublisher(GetConfigurationSettingPublisher());

            InitDiagnostics();

            return base.OnStart();
        }

        private void InitDiagnostics()
        {
            DiagnosticMonitorConfiguration dmc;

            dmc = DiagnosticMonitor.GetDefaultInitialConfiguration();

            dmc.Logs.ScheduledTransferPeriod = TimeSpan.FromSeconds(15);
            dmc.Logs.ScheduledTransferLogLevelFilter = LogLevel.Verbose;

            DiagnosticMonitor.Start("Storage", dmc);

        }
    }
}
