﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.WindowsAzure.StorageClient;
using Microsoft.WindowsAzure;

namespace AzureBlog_TableServices
{
    // Benötigt Assembly System.Data.Services 
    // und Microsoft.WindowsAzure.StorageClient
    public class BlogContext : TableServiceContext { 
        
        public BlogContext(string a, StorageCredentials c) : base(a, c) { } 
        
        public static BlogContext Create() { 
            CloudStorageAccount account; 
            CloudTableClient tableClient;
            BlogContext ctx;
            
            account = CloudStorageAccount.FromConfigurationSetting("Storage");
            tableClient = account.CreateCloudTableClient();

            ctx = new BlogContext(account.TableEndpoint.ToString(), account.Credentials);

            tableClient.CreateTableIfNotExist("Beitrag");
            tableClient.CreateTableIfNotExist("BeitragKategorieLink");

            InitAutorTable(tableClient, ctx);
            InitKategorieTable(tableClient, ctx);

            return ctx;
        }

        private static void InitAutorTable(CloudTableClient tableClient, BlogContext ctx)
        {
            tableClient.DeleteTableIfExist("Autor");
            if (!tableClient.DoesTableExist("Autor"))
            {
                tableClient.CreateTable("Autor");

                AutorEntity a1 = new AutorEntity();
                a1.AutorID = "h.schwichtenberg@it-visions.de";
                a1.Vorname = "Holger";
                a1.Nachname = "Schwichtenberg";

                AutorEntity a2 = new AutorEntity();
                a2.AutorID = "manfred.steyer@it-visions.de";
                a2.Vorname = "Manfred";
                a2.Nachname = "Steyer";

                ctx.AddAutor(a1);
                ctx.AddAutor(a2);
                ctx.SaveChanges();
            }
        }


        private static void InitKategorieTable(CloudTableClient tableClient, BlogContext ctx)
        {
            tableClient.DeleteTableIfExist("Kategorie");
            if (!tableClient.DoesTableExist("Kategorie"))
            {
                tableClient.CreateTable("Kategorie");

                KategorieEntity k1 = new KategorieEntity();
                k1.KategorieId = "1";
                k1.KategorieName = "Windows Azure";

                KategorieEntity k2 = new KategorieEntity();
                k2.KategorieId = "2";
                k2.KategorieName = ".NET 4";

                ctx.AddKategorie(k1);
                ctx.AddKategorie(k2);

                ctx.SaveChanges();
            }
        }

        public IQueryable<AutorEntity> Autoren
        {
            get { return base.CreateQuery<AutorEntity>("Autor"); } 
        }

        public void AddAutor(AutorEntity autor)
        {
            this.AddObject("Autor", autor);
        }

        public IQueryable<KategorieEntity> Kategorien
        {
            get { return base.CreateQuery<KategorieEntity>("Kategorie"); }
        }

        public void AddKategorie(KategorieEntity autor)
        {
            this.AddObject("Kategorie", autor);
        }

        public IQueryable<BeitragEntity> Beitraege
        {
            get { return base.CreateQuery<BeitragEntity>("Beitrag"); }
        }

        public void AddBeitrag(BeitragEntity beitrag)
        {
            this.AddObject("Beitrag", beitrag);
        }

        public IQueryable<BeitragKategorieLink> BeitragKategorieLinks
        {
            get { return base.CreateQuery<BeitragKategorieLink>("BeitragKategorieLink"); }
        }

        public void AddBeitragKategorieLink(BeitragKategorieLink link)
        {
            this.AddObject("BeitragKategorieLink", link);
        }
        
    }
}
