﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Reflection;
using System.Collections;

namespace ITVisions
{
  public static class ObjectExtensions
  {

 
      public static string GetWholeMessage(this Exception ex)
      {
        string ausgabe = ex.GetType().ToString() + ": " + ex.Message + "\n";
        if (ex.InnerException != null) ausgabe += GetWholeMessage(ex.InnerException);
        return ausgabe;
      }

 

    /// <summary>
    /// Entfernt führende "0" aus einer Zeichenkette
    /// </summary>
    /// <param name="obj"></param>
    /// <returns></returns>
    public static string RemoveLeadingZeros(this string obj)
    {
      while (!String.IsNullOrEmpty(obj) && obj.StartsWith("0"))
      {
        obj = obj.Substring(1, obj.Length - 1);

      }
      return obj;
    }


    public static string ConvertListToCSV(this IEnumerable list, bool OnlyWithValue = false)
    {
      string s = "";
      foreach (object x in list)
      {
        s += x.ConvertToCSV() + "\n";
      }
      return s;
    }

    public static string ConvertListToString(this IEnumerable list, bool OnlyWithValue = false)
    {
      string s = "";
      foreach (object x in list)
      {
        s += x.ToString() + "\n";
      }
      return s;
    }


    public static string ConvertToCSV(this Object obj, bool OnlyWithValue = false)
    {
      System.Type t = obj.GetType();
      string s = "";
      foreach (FieldInfo f in t.GetFields())
      {

        object val = f.GetValue(obj);
        if (OnlyWithValue == false || (val != null && val.ToString() != ""))
        {
          if (s != "")
          {
            s += ";";
          }
          s += val;
        }
      }

      foreach (PropertyInfo p in t.GetProperties())
      {
     
        try
        {
          object val = p.GetValue(obj, null);
          if (OnlyWithValue == false || (val != null && val.ToString().Trim() != ""))
          {
            if (s != "")
            {
              s += ";";
            }
            s += val;
          }
        }
        catch (Exception ex)
        {
          s += ex.Message;
        }
      }
      return s;
    }

    public static string ConvertToStrings(this Object obj, bool OnlyWithValue = false)
    {
      return obj.ConvertToCSV(OnlyWithValue).Replace(";", "\n");
    }

    public static string ConvertToStringsWithNames(this Object obj)
    {
      if (obj == null) return "";
      System.Type t = obj.GetType();
      string s = "";
      foreach (FieldInfo f in t.GetFields())
      {
        if (s != "")
        {
          s += "\n";
        }
        object val = f.GetValue(obj);
        s += f.Name + ": " + val;
      }

      foreach (PropertyInfo p in t.GetProperties())
      {
        if (s != "")
        {
          s += "\n";
        }
        try
        {
          object val = p.GetValue(obj, null);
          s += p.Name + ": " + val;
        }
        catch (Exception ex)
        {
          s += p.Name + ": " + ex.Message;
        }
      }
      return s;
    }
  }
}
