﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using AzureBlog_TableServices;
using AzureBlog_Modell;

namespace AzureBlog_Logik
{
    public class AutorManager
    {
        BlogContext ctx = BlogContext.Create();


        public AzureBlog_Modell.Autor Get(string autorID)
        {
            AutorEntity entity;
            Autor result;
    
            entity = ctx.Autoren
                        .Where(a => a.PartitionKey == autorID.ToString())
                        .FirstOrDefault();

            result = MapAutor(entity);
            
            return result;

        }

        private Autor MapAutor(AutorEntity entity)
        {
            Autor result;
            
            if (entity == null) return null;

            result = new Autor();
            result.AutorID = entity.AutorID;
            result.Vorname = entity.Vorname;
            result.Nachname = entity.Nachname;
            result.EMail = entity.EMail;
            
            return result;
        }



        public List<AzureBlog_Modell.Autor> GetAll()
        {
            List<AutorEntity> list = ctx.Autoren.ToList();
            List<Autor> result = new List<Autor>();

            foreach (var autor in list)
            {
                result.Add(MapAutor(autor));
            }

            return result;
        }

        
    }
}
