﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using AzureBlog_Modell;
using Microsoft.WindowsAzure.ServiceRuntime;

namespace AzureBlog_Logik
{
 /// <summary>
 /// Factory-Klasse für den EF-Kontext
 /// Assembly Microsoft.WindowsAzure.ServiceRuntime einbinden!
 /// </summary>
 static class EFContextFactory
 {
  public static AzureBlogEntities Create()
  {
   if (Microsoft.WindowsAzure.ServiceRuntime.RoleEnvironment.IsAvailable)
   { // Läuft in Azure
    string cnnstr = RoleEnvironment.GetConfigurationSettingValue("AzureBlogEntities");
    return new AzureBlogEntities(cnnstr);
   }
   else
   {
    // läuft nicht in Azure
    string cnnstr = System.Configuration.ConfigurationManager.ConnectionStrings["AzureBlogEntities"].ConnectionString;
    return new AzureBlogEntities(cnnstr);
   }
  }
 }
}
